/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.coverage.printer;

import java.util.Locale;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.remote.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.report.model.MuleFlow;
import org.mule.munit.remote.coverage.report.model.MuleResource;

public class ConsolePrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "Console";
    private Log log;

    public ConsolePrinter(Log log) {
        this.log = log;
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"\t\t\t\tMUnit Coverage Report");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"");
        for (MuleResource mr : report.getResources()) {
            this.log.info((CharSequence)"-------------------------------------------------------------------------------");
            if (mr.getCoverage() != -1.0) {
                this.log.info((CharSequence)("Resource File: " + mr.getName() + " - Flows: " + mr.getFlows().size() + " - Weight: " + this.formatDecimals(mr.getWeight()) + " -  Coverage: " + this.formatDecimals(mr.getCoverage()) + "%"));
            } else {
                this.log.info((CharSequence)("Resource File: " + mr.getName() + " - Flows: " + mr.getFlows().size() + " - Weight: " + this.formatDecimals(mr.getWeight()) + " -  Coverage: N/A"));
            }
            this.log.info((CharSequence)"-------------------------------------------------------------------------------");
            for (MuleFlow mf : mr.getFlows()) {
                this.log.info((CharSequence)("  * " + mf.getPrintableType() + ": " + mf.getName() + " - Covered (MP): " + mf.getCoveredLocations().size() + " - Total (MP): " + mf.getLocations().size() + " - Coverage: " + this.formatDecimals(mf.getCoverage()) + "%"));
            }
        }
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)"\t\t\t\t\tSummary");
        this.log.info((CharSequence)"===============================================================================");
        this.log.info((CharSequence)("  * CMPs: " + report.getApplicationCoveredMessageProcessorCount()));
        this.log.info((CharSequence)("  * MPs: " + report.getApplicationMessageProcessorCount()));
        this.log.info((CharSequence)("  * Flows: " + report.getApplicationFlowCount()));
        this.log.info((CharSequence)("  * Resources: " + report.getResources().size()));
        this.log.info((CharSequence)"===============================================================================");
        if (report.getApplicationFlowCount() > 0) {
            this.log.info((CharSequence)("\t\t\t\t** Application Coverage: " + this.formatDecimals(report.getCoverage()) + "% **"));
        } else {
            this.log.info((CharSequence)"\t\t\t\t** Application Coverage: N/A **");
        }
        this.log.info((CharSequence)"===============================================================================");
    }

    private String formatDecimals(Double number) {
        return String.format(Locale.ENGLISH, "%.2f", number);
    }
}

