/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.coverage.printer;

import com.google.common.base.Preconditions;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import org.mule.munit.Coverage;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.coverage.printer.MavenCoverageReportPrinter;
import org.mule.munit.coverage.printer.ReportFileWriter;
import org.mule.munit.remote.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.report.model.MuleResource;

public class HtmlPrinter
implements MavenCoverageReportPrinter {
    public static final String PRINTER_NAME = "HTML";
    private static final String ASSETS_FOLDER = "assets";
    private static final String STYLES_FOLDER = "styles";
    private static final String SCRIPTS_FOLDER = "js";
    private static final String BASE_TEMPLATE_FOLDER = "/templates";
    private static final String SUMMARY_TEMPLATE_FILE_NAME = "summary.ftl";
    private static final String RESOURCE_TEMPLATE_FILE_NAME = "resource.ftl";
    private static final String MULESOFT_STYLES = "mulesoft-styles.css";
    private static final String TSORTER_STYLES = "tsorter.css";
    private static final String MULESOFT_ICON = "icons/004_logo.svg";
    private static final String MULESOFT_ICON_TTF = "fonts/muleicons.ttf";
    private static final String TSORTER_SCRIPT = "tsorter.min.js";
    private final File reportDirectory;
    private Coverage coverageConfig;
    private ReportFileWriter reportFileWriter = new ReportFileWriter();
    private Configuration freemarkerConfig;

    public HtmlPrinter(Coverage coverageConfig, File reportDirectory) {
        Preconditions.checkNotNull((Object)coverageConfig, (Object)"Coverage configuration cannot be null");
        Preconditions.checkNotNull((Object)reportDirectory, (Object)"Report directory cannot be null");
        this.coverageConfig = coverageConfig;
        this.reportDirectory = reportDirectory;
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_23);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), BASE_TEMPLATE_FOLDER);
    }

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        try {
            this.printSummary(report);
            this.printResources(report);
            this.addAssets();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReportFileWriter(ReportFileWriter reportFileWriter) {
        this.reportFileWriter = reportFileWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSummary(ApplicationCoverageReport report) throws IOException {
        StringWriter writer = null;
        try {
            Template summaryTemplate = this.getTemplate(SUMMARY_TEMPLATE_FILE_NAME);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("applicationFlowCount", report.getApplicationFlowCount());
            data.put("applicationCoverage", report.getCoverage());
            data.put("applicationResourceLines", report.getResources());
            data.put("configuration", this.coverageConfig);
            writer = new StringWriter();
            summaryTemplate.process(data, (Writer)writer);
            this.reportFileWriter.writeToFile(new File(this.reportDirectory, "summary.html"), writer.getBuffer().toString());
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResources(ApplicationCoverageReport report) throws IOException {
        StringWriter writer = null;
        for (MuleResource mr : report.getResources()) {
            try {
                Template resourceTemplate = this.getTemplate(RESOURCE_TEMPLATE_FILE_NAME);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("resourceName", mr.getName());
                data.put("resourceMpCovered", mr.getCoveredMessageProcessorCount());
                data.put("resourceMpCount", mr.getMessageProcessorCount());
                data.put("resourceCoverage", mr.getCoverage());
                data.put("flowLines", mr.getFlows());
                data.put("configuration", this.coverageConfig);
                writer = new StringWriter();
                resourceTemplate.process(data, (Writer)writer);
                this.reportFileWriter.writeToFile(new File(this.reportDirectory, this.reportFileWriter.getHtmlFileName(mr.getName())), writer.getBuffer().toString());
                IOUtils.closeQuietly((Writer)writer);
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
    }

    private Template getTemplate(String resourceTemplateFileName) throws IOException {
        return this.freemarkerConfig.getTemplate(resourceTemplateFileName, Locale.US);
    }

    private void addAssets() {
        this.addStyles();
        this.addScripts();
    }

    private void addStyles() {
        try {
            Path stylesPath = this.reportDirectory.toPath().resolve(ASSETS_FOLDER).resolve(STYLES_FOLDER);
            this.reportFileWriter.copyFile(MULESOFT_STYLES, stylesPath.resolve(MULESOFT_STYLES).toFile());
            this.reportFileWriter.copyFile(MULESOFT_ICON, stylesPath.resolve(MULESOFT_ICON).toFile());
            this.reportFileWriter.copyFile(MULESOFT_ICON_TTF, stylesPath.resolve(MULESOFT_ICON_TTF).toFile());
            this.reportFileWriter.copyFile(TSORTER_STYLES, stylesPath.resolve(TSORTER_STYLES).toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addScripts() {
        try {
            Path scriptsPath = this.reportDirectory.toPath().resolve(ASSETS_FOLDER).resolve(SCRIPTS_FOLDER);
            this.reportFileWriter.copyFile(TSORTER_SCRIPT, scriptsPath.resolve(TSORTER_SCRIPT).toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

