/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.coverage.printer;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class ReportFileWriter {
    public String getHtmlFileName(String resourceName) {
        String htmlFileName = resourceName;
        htmlFileName = htmlFileName.substring(0, htmlFileName.indexOf(".xml")) + "-report.html";
        return htmlFileName;
    }

    public void writeToFile(File file, String content) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null");
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(content);
        bw.flush();
        bw.close();
        fw.close();
    }

    public void copyFile(String originPath, File destination) throws IOException {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(originPath);
        FileUtils.copyInputStreamToFile((InputStream)resource, (File)destination);
    }
}

