/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import org.apache.maven.plugin.logging.Log;

/**
 * <p>
 * Generates the final classpath for the new JVM
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class ClasspathManager {

  private Log log;
  private Class runnerClass;
  private List<String> classpathElements;

  public ClasspathManager(List<String> classpathElements, Class runnerClass, Log log) {
    this.classpathElements = classpathElements;
    this.runnerClass = runnerClass;
    this.log = log;
  }

  public List<String> getEffectiveClasspath() {
    List<String> effectiveClasspath = new ArrayList<>();
    addRunnerClassDependency(effectiveClasspath);

    log.debug("Classpath: ");
    effectiveClasspath.forEach(classpathEntry -> log.debug(classpathEntry));

    return effectiveClasspath;
  }

  private void addRunnerClassDependency(List<String> effectiveClasspath) {
    if (runnerClass != null) {
      String runnerClassDependency = runnerClass.getProtectionDomain().getCodeSource().getLocation().getPath();
      effectiveClasspath.add(runnerClassDependency);
      log.debug(String.format("Runner dependency added: %s", runnerClassDependency));
    } else {
      log.info("The runner class provided is null");
    }
  }

}
