/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

/**
 * <p>
 * Model to represent the test case in the xml report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
@XStreamAlias(value = "testcase")
public class TestCase {

  @XStreamAsAttribute
  private float time;
  @XStreamAsAttribute
  private String name;
  @XStreamAsAttribute
  @XStreamAlias(value = "classname")
  private String className;

  private String failure;
  private String error;
  private Skipped skipped;


  public TestCase(float time, String className, String name) {
    this.time = time;
    this.className = className;
    this.name = name;
  }

  public float getTime() {
    return time;
  }

  public String getClassname() {
    return className;
  }

  public String getName() {
    return name;
  }

  public String getFailure() {
    return failure;
  }

  public void setFailure(String failure) {
    this.failure = failure;
  }

  public String getError() {
    return error;
  }

  public void setError(String error) {
    this.error = error;
  }

  public void setSkipped(boolean skipped) {
    this.skipped = skipped ? new Skipped() : null;
  }
}
