/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mojo.locators;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.munit.mojo.locators.FilesLocator;

public class TestSuiteFilesLocator
implements FilesLocator {
    private static final String MUNIT_TEST_SUITE_FILE_MARKER = "munit:config";
    private static final String[] MUNIT_TEST_SUITE_FILE_EXTENSIONS = new String[]{"xml"};

    @Override
    public List<File> locateFiles(File folder) {
        return FileUtils.listFiles((File)folder, (String[])MUNIT_TEST_SUITE_FILE_EXTENSIONS, (boolean)true).stream().filter(this::isValidMunitTestSuiteFile).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidMunitTestSuiteFile(File file) {
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, StandardCharsets.UTF_8.name());
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.contains(MUNIT_TEST_SUITE_FILE_MARKER)) continue;
                scanner.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
        return false;
    }
}

