/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.structure;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.remote.ApplicationStructureGenerator;
import org.mule.munit.remote.DomainStructureGenerator;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.util.maven.MuleApplicationDependencyFinder;

public class WorkingDirectoryGenerator {
    protected Log log;
    private MavenProject project;
    private File workingDirectory;
    private Path generatedDomainStructurePath;
    private Path generatedApplicationStructurePath;

    public WorkingDirectoryGenerator(Log log, MavenProject project) {
        Preconditions.checkArgument((log != null ? 1 : 0) != 0, (Object)"Log must not be null");
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"Project must not be null");
        this.log = log;
        this.project = project;
    }

    public Path generateWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = new File(this.project.getBuild().getDirectory(), FolderNames.MUNIT_WORKING_DIR.value() + "-" + Long.toString(System.nanoTime()));
        }
        return this.workingDirectory.toPath();
    }

    public Path generateApplicationStructure() throws MojoExecutionException {
        if (this.generatedApplicationStructurePath == null) {
            Path baseFolderPath = this.project.getBasedir().toPath();
            Path sourceFolderPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            Path destinationPath = this.generateWorkingDirectory();
            try {
                this.log.debug((CharSequence)("Attempting to create application structure source: " + sourceFolderPath.toFile().getAbsolutePath() + " - destination: " + destinationPath));
                this.generatedApplicationStructurePath = this.getApplicationStructureGenerator(baseFolderPath, sourceFolderPath, destinationPath).generate();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Fail to create application structure", e);
            }
        }
        return this.generatedApplicationStructurePath;
    }

    public Optional<Path> generateDomainStructure() throws MojoExecutionException {
        Optional<Artifact> domainArtifact;
        if (this.generatedDomainStructurePath == null && (domainArtifact = this.getMuleApplicationDependencyFinder().findMuleDomainArtifact()).isPresent()) {
            File domainFile = domainArtifact.get().getFile();
            try {
                this.log.debug((CharSequence)("Attempting to create domain structure source: " + domainFile.getAbsolutePath() + " - destination: " + this.generateWorkingDirectory()));
                this.generatedDomainStructurePath = this.getDomainStructureGenerator(domainArtifact, domainFile).generate();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Fail to create domain structure", e);
            }
        }
        return Optional.ofNullable(this.generatedDomainStructurePath);
    }

    protected MuleApplicationDependencyFinder getMuleApplicationDependencyFinder() {
        return new MuleApplicationDependencyFinder(this.project);
    }

    protected DomainStructureGenerator getDomainStructureGenerator(Optional<Artifact> domainArtifact, File domainFile) {
        String domainName = domainArtifact.get().getArtifactId() + "-" + domainArtifact.get().getBaseVersion() + "-" + domainArtifact.get().getClassifier();
        return new DomainStructureGenerator(domainFile.toPath(), this.generateWorkingDirectory(), domainName);
    }

    protected ApplicationStructureGenerator getApplicationStructureGenerator(Path baseFolderPath, Path sourceFolderPath, Path destinationPath) {
        return new ApplicationStructureGenerator(baseFolderPath, sourceFolderPath, destinationPath, this.project.getArtifactId());
    }
}

