/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mojo.locators;

import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * Locates all Mule Configuration Files
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MuleConfigurationFilesLocator implements FilesLocator {

  private static final String MUNIT_TEST_SUITE_FILE_EXTENSION = "xml";

  public List<File> locateFiles(File folder) {
    List<File> locatedFiles = FileUtils
        .listFiles(folder, new String[] {MUNIT_TEST_SUITE_FILE_EXTENSION}, true)
        .stream()
        .collect(Collectors.toList());

    return locatedFiles;
  }

}
