/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mojo;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class TestSuiteFileFilter {
    private static final String SINGLE_TEST_NAME_TOKEN = "#";
    private final Log log;
    private String testNameRegEx;
    private String testSuiteRegEx;

    public TestSuiteFileFilter(Log log, String filter) {
        Preconditions.checkNotNull((Object)log, (Object)"The log must not be null");
        this.log = log;
        if (StringUtils.isNotBlank((CharSequence)filter) && filter.contains(SINGLE_TEST_NAME_TOKEN)) {
            this.testSuiteRegEx = filter.substring(0, filter.indexOf(SINGLE_TEST_NAME_TOKEN));
            this.testNameRegEx = filter.substring(filter.indexOf(SINGLE_TEST_NAME_TOKEN) + 1);
        } else {
            this.testSuiteRegEx = filter;
            this.testNameRegEx = "";
        }
    }

    public String getTestNameRegEx() {
        return this.testNameRegEx;
    }

    public boolean shouldFilter(String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileName), (Object)"The fileName should not be null nor empty");
        if (StringUtils.isBlank((CharSequence)this.testSuiteRegEx)) {
            return true;
        }
        boolean result = fileName.matches(this.testSuiteRegEx);
        if (!result) {
            this.log.debug((CharSequence)("MUnit Test Suite file " + fileName + " skipped. It doesn't match filter criteria: [" + this.testSuiteRegEx + "]"));
            return false;
        }
        return true;
    }
}

