/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.mojo.TestSuiteFileFilter;
import org.mule.munit.mojo.locators.Log4J2ConfigurationLocator;
import org.mule.munit.mojo.locators.TestSuiteFilesLocator;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.MavenConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.NotifierParameter;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;
import org.mule.munit.remote.notifiers.ConsoleNotifier;
import org.mule.munit.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.util.MuleApplicationModelLoader;

public class RunConfigurationFactory {
    public static final String RUN_TOKEN_CONSOLE_PARAMETER = "runToken";
    private Log log;
    private String munitTags;
    private Boolean skipAfterFailure;
    private TestSuiteFileFilter testSuiteFileFilter;
    private WorkingDirectoryGenerator workingDirectoryGenerator;
    private MuleApplicationModelLoader muleApplicationModelLoader;
    private File munitSrcFolder;
    private Coverage coverage;
    private String pluginVersion;
    protected MavenProject project;
    protected MavenSession session;

    public RunConfigurationFactory(Log log, String munitTest, String munitTags, Boolean skipAfterFailure, MuleApplicationModelLoader muleApplicationModelLoader, WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder, Coverage coverage, String pluginVersion, MavenProject project, MavenSession session) {
        Preconditions.checkNotNull((Object)log, (Object)"The log must not be null");
        Preconditions.checkNotNull((Object)skipAfterFailure, (Object)"The skipAfterFailure must not be null");
        Preconditions.checkNotNull((Object)muleApplicationModelLoader, (Object)"The muleApplicationModelLoader must not be null nor empty");
        Preconditions.checkNotNull((Object)workingDirectoryGenerator, (Object)"The WorkingDirectoryGenerator must not be null");
        Preconditions.checkNotNull((Object)munitSrcFolder, (Object)"The munitSrcFolder must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginVersion), (Object)"The pluginVersion must not be null nor empty");
        Preconditions.checkNotNull((Object)project, (Object)"The project must not be null");
        Preconditions.checkNotNull((Object)session, (Object)"The session must not be null");
        this.log = log;
        this.munitTags = munitTags;
        this.skipAfterFailure = skipAfterFailure;
        this.muleApplicationModelLoader = muleApplicationModelLoader;
        this.testSuiteFileFilter = new TestSuiteFileFilter(log, munitTest);
        this.munitSrcFolder = munitSrcFolder;
        this.workingDirectoryGenerator = workingDirectoryGenerator;
        this.coverage = coverage;
        this.pluginVersion = pluginVersion;
        this.project = project;
        this.session = session;
    }

    public RunConfiguration createRunConfiguration() throws MojoExecutionException {
        String runToken = UUID.randomUUID().toString();
        ArrayList<NotifierParameter> consoleParameters = new ArrayList<NotifierParameter>();
        consoleParameters.add(new NotifierParameter(RUN_TOKEN_CONSOLE_PARAMETER, String.class.getCanonicalName(), runToken));
        NotifierConfiguration consoleNotifierConfiguration = new NotifierConfiguration.NotifierConfigurationBuilder().withClazz(ConsoleNotifier.class.getCanonicalName()).withParameters(consoleParameters).build();
        ArrayList<NotifierConfiguration> notifierConfigurations = new ArrayList<NotifierConfiguration>();
        notifierConfigurations.add(consoleNotifierConfiguration);
        MavenConfiguration mavenConfiguration = new MavenConfiguration.MavenConfigurationBuilder().withMavenRepositoryDirectoryPath(this.session.getLocalRepository().getBasedir()).withSettingsXmlFilePath(this.session.getRequest().getUserSettingsFile().getAbsolutePath()).withGlobalSettingsXmlFilePath(this.session.getRequest().getGlobalSettingsFile().getAbsolutePath()).withForcePolicyUpdate(Boolean.valueOf(true)).withOfflineMode(Boolean.valueOf(this.session.isOffline())).build();
        ContainerConfiguration.ContainerConfigurationBuilder containerConfigurationBuilder = new ContainerConfiguration.ContainerConfigurationBuilder().withRuntimeId(this.muleApplicationModelLoader.getRuntimeVersion()).withProduct(this.muleApplicationModelLoader.getRuntimeProduct()).withMunitWorkingDirectoryPath(this.workingDirectoryGenerator.generateWorkingDirectory().toFile().getAbsolutePath()).withLog4JConfigurationFilePath(this.getLog4JConfigurationFilePath()).withMavenConfiguration(mavenConfiguration);
        Boolean shouldRunCoverage = new CoverageAuthorizator(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct()).shouldRunCoverage();
        CoverageConfiguration coverageConfiguration = this.buildCoverageConfiguration(shouldRunCoverage);
        if (shouldRunCoverage.booleanValue()) {
            String coveragePluginVersion = this.pluginVersion;
            ServerPluginConfiguration coveragePluginConfiguration = this.getCoverageServerPluginConfiguration(coveragePluginVersion);
            containerConfigurationBuilder.withServerPluginConfiguration(coveragePluginConfiguration);
        }
        ContainerConfiguration containerConfiguration = containerConfigurationBuilder.build();
        RunConfiguration.RunConfigurationBuilder builder = new RunConfiguration.RunConfigurationBuilder();
        String testToRunName = this.testSuiteFileFilter.getTestNameRegEx();
        builder.withRunToken(runToken).withProjectName(this.project.getArtifactId()).withTags((Set)(this.munitTags == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(this.munitTags.split(","))))).withSkipAfterFailure(this.skipAfterFailure).withTestNames(StringUtils.isBlank((CharSequence)testToRunName) ? Collections.emptySet() : Sets.newHashSet((Object[])testToRunName.split(","))).withSuitePaths(this.locateMunitTestSuites()).withNotifierConfigurations(notifierConfigurations).withCoverageConfiguration(coverageConfiguration).withContainerConfiguration(containerConfiguration);
        builder.withDomainLocation(this.workingDirectoryGenerator.generateDomainStructure().map(domainPath -> domainPath.toFile().getAbsolutePath()).orElse(""));
        return builder.build();
    }

    private CoverageConfiguration buildCoverageConfiguration(Boolean shouldRunCoverage) {
        Set coverageIgnoreFlows = this.coverage != null ? this.coverage.getIgnoreFlows() : Collections.emptySet();
        Set coverageIgnoreFiles = this.coverage != null ? this.coverage.getIgnoreFiles() : Collections.emptySet();
        CoverageConfiguration coverageConfiguration = new CoverageConfiguration.CoverageConfigurationBuilder().withShouldRunCoverage(shouldRunCoverage).withSuitePaths(this.locateMunitTestSuites()).withIgnoredFiles(coverageIgnoreFiles).withIgnoredFlowNames(coverageIgnoreFlows).build();
        return coverageConfiguration;
    }

    private ServerPluginConfiguration getCoverageServerPluginConfiguration(String coveragePluginVersion) {
        return new ServerPluginConfiguration.ServerPluginConfigurationBuilder().withGroupId("com.mulesoft.munit.plugins").withArtifactId("munit-coverage-plugin").withVersion(coveragePluginVersion).withClassifier("mule-server-plugin").withType("jar").build();
    }

    private String getLog4JConfigurationFilePath() {
        return this.getLog4JConfigurationFile().isPresent() ? this.getLog4JConfigurationFile().get().getAbsolutePath() : "";
    }

    private Optional<File> getLog4JConfigurationFile() {
        List<File> files = new Log4J2ConfigurationLocator(this.log).locateFiles(new File(this.project.getBuild().getDirectory()));
        return files.isEmpty() ? Optional.empty() : Optional.of(files.get(0));
    }

    private Set<String> locateMunitTestSuites() {
        return new TestSuiteFilesLocator().locateFiles(this.munitSrcFolder).stream().map(suiteFile -> this.munitSrcFolder.toURI().relativize(suiteFile.toURI()).toASCIIString()).filter(suitePath -> this.testSuiteFileFilter.shouldFilter((String)suitePath)).collect(Collectors.toSet());
    }
}

