/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util.maven;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.mule.tools.api.packager.packaging.Classifier;

public class MuleApplicationDependencyFinder {
    private MavenProject project;

    public MuleApplicationDependencyFinder(MavenProject project) {
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (Object)"The project must not be null");
        this.project = project;
    }

    public Optional<Artifact> findMuleDomainArtifact() {
        Optional<Dependency> domainDependency = this.findMuleDomainDependency();
        if (domainDependency.isPresent()) {
            return this.findMuleDomainArtifact(MuleApplicationDependencyFinder.buildDependencyId(domainDependency.get()));
        }
        return Optional.empty();
    }

    public Optional<Artifact> findMuleDomainArtifact(String artifactId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)artifactId), (Object)"The artifact id must not be null nor empty");
        Optional<Artifact> artifact = this.project.getArtifacts().stream().filter(a -> a.getId().equals(artifactId)).findFirst();
        return artifact;
    }

    public Optional<Dependency> findMuleDomainDependency() {
        Optional<Dependency> dependency = this.project.getDependencies().stream().filter(d -> StringUtils.isBlank((CharSequence)d.getClassifier()) ? false : d.getClassifier().equals(Classifier.MULE_DOMAIN.toString())).findFirst();
        return dependency;
    }

    public static String buildDependencyId(Dependency dependency) {
        Preconditions.checkArgument((dependency != null ? 1 : 0) != 0, (Object)"The dependency must not be null");
        StringBuilder dependencyId = new StringBuilder();
        dependencyId.append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getType()).append(":");
        if (StringUtils.isNotBlank((CharSequence)dependency.getClassifier())) {
            dependencyId.append(dependency.getClassifier());
            dependencyId.append(":");
        }
        dependencyId.append(dependency.getVersion());
        return dependencyId.toString();
    }
}

