/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.printer;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

import org.apache.maven.plugin.logging.Log;
import org.mule.munit.runner.model.RunResult;

/**
 * <p>
 * Prints the test output to a file
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class TestOutputFilePrinter extends FileResultPrinter {

  private static final String TXT_REPORT_HEADER = "munit.";

  public TestOutputFilePrinter(File reportBasePath, Log log) {
    super(reportBasePath, log);
  }

  public void print(RunResult runResult) {
    Map<String, List<String>> suiteOutputs = runResult.getSuiteOutputs();
    try {
      for (Map.Entry<String, List<String>> suiteOutput : suiteOutputs.entrySet()) {
        String suiteRelativePath = suiteOutput.getKey();
        String suiteReportName = suiteRelativePath.replace("/", ".");
        suiteReportName = suiteReportName.replace(".xml", "-output.txt");
        PrintStream out = getResultPrintStream(TXT_REPORT_HEADER + suiteReportName);
        log.debug(String.format("Writing %s file in %s", suiteReportName, reportBasePath));
        for (String outputLine : suiteOutput.getValue()) {
          out.println(outputLine);
        }
      }
    } catch (FileNotFoundException | UnsupportedEncodingException e) {
      e.printStackTrace();
    }
  }
}
