/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.common.util.FileUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;

public class MuleApplicationModelLoader {
    private MuleApplicationModel muleApplicationModel;
    private String runtimeVersion;
    private String runtimeProduct;
    private Log log;

    public MuleApplicationModelLoader(File muleApplicationJsonFile, String runtimeVersion, String runtimeProduct, Log log) throws MojoExecutionException {
        try {
            this.muleApplicationModel = this.getMuleApplicationModel(muleApplicationJsonFile);
        }
        catch (IOException e) {
            String message = "Fail to read mule application file from " + muleApplicationJsonFile;
            log.error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
        this.runtimeVersion = runtimeVersion;
        this.runtimeProduct = runtimeProduct;
        this.log = log;
    }

    public String getRuntimeVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        String runtimeVersion = this.muleApplicationModel.getMinMuleVersion();
        this.log.debug((CharSequence)("Runtime version set to " + runtimeVersion + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeVersion;
    }

    public String getRuntimeProduct() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeProduct)) {
            return this.runtimeProduct;
        }
        String runtimeProduct = this.muleApplicationModel.getRequiredProduct().name();
        this.log.debug((CharSequence)("Runtime product set to " + runtimeProduct + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeProduct;
    }

    private MuleApplicationModel getMuleApplicationModel(File muleArtifactJsonFile) throws IOException {
        return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleArtifactJsonFile, (Charset)Charset.defaultCharset()));
    }
}

