/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageLimitsChecker;
import org.mule.munit.mojo.ApplicationResultPrinterFactory;
import org.mule.munit.mojo.exceptions.MojoExecutionExceptionFactory;
import org.mule.munit.plugin.maven.AbstractMunitMojo;
import org.mule.munit.plugin.maven.RuntimeProducts;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.util.MuleApplicationModelLoader;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.project.ApplicationStructureGenerator;
import org.mule.munit.remote.api.project.MuleApplicationStructureGenerator;
import org.mule.munit.util.ApplicationRunConfigurationFactory;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class MUnitMojo
extends AbstractMunitMojo {
    @Parameter(property="munit.coverage")
    protected Coverage coverage;
    @Parameter(defaultValue="${munit.randomFailMessages}")
    private boolean randomFailMessages = false;
    @Parameter(defaultValue="${plugin.version}")
    protected String pluginVersion;
    @Parameter(property="munit.coverageReportData", defaultValue="${project.build.directory}/munit-reports/coverage-report.data")
    protected File coverageReportDataFile;
    @Parameter(property="munit.coverageConfigData", defaultValue="${project.build.directory}/munit-reports/coverage-config.data")
    protected File coverageConfigDataFile;
    @Parameter(property="runtimeVersion")
    public String runtimeVersion;
    @Parameter(property="runtimeProduct")
    public String runtimeProduct;
    protected MojoExecutionExceptionFactory exceptionFactory;
    protected CoverageLimitsChecker coverageLimitsChecker;

    protected void init() throws MojoExecutionException {
        super.init();
        this.exceptionFactory = new MojoExecutionExceptionFactory(this.randomFailMessages);
        this.coverageLimitsChecker = new CoverageLimitsChecker(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct(), this.getLog());
    }

    protected void handleRunResult(TargetRuntime targetRuntime, RunResult runResult) {
        super.handleRunResult(targetRuntime, runResult);
        runResult.getApplicationCoverageReport().ifPresent(this.coverageLimitsChecker::setCoverageReport);
        this.saveRunDataToFile(runResult);
    }

    protected void failBuildIfNecessary(Map<TargetRuntime, RunResult> runResults) throws MojoExecutionException {
        try {
            super.failBuildIfNecessary(runResults);
        }
        catch (MojoExecutionException e) {
            throw this.exceptionFactory.buildException("Build Failed", e);
        }
        if (this.coverage != null && this.coverage.isRunCoverage().booleanValue() && !RuntimeProducts.EE.value().equals(this.muleApplicationModelLoader.getRuntimeProduct())) {
            this.getLog().warn((CharSequence)"Coverage is a EE only feature and you've selected to run over CE");
        }
        if (this.coverageLimitsChecker.failBuild().booleanValue()) {
            throw new MojoExecutionException("Build Failed", (Exception)new MojoFailureException("Coverage limits were not reached"));
        }
    }

    protected Map<TargetRuntime, RunConfiguration> getRunConfigurations() throws MojoExecutionException {
        TargetRuntime targetRuntime = new TargetRuntime(this.muleApplicationModelLoader.getRuntimeVersion(), this.muleApplicationModelLoader.getRuntimeProduct());
        return ImmutableMap.of((Object)targetRuntime, (Object)new ApplicationRunConfigurationFactory(this.getLog(), this.munitTest, this.munitTags, this.skipAfterFailure, targetRuntime, this.workingDirectoryGenerator, this.munitTestsDirectory, this.coverage, this.pluginVersion, this.project, this.session).create());
    }

    protected ResultPrinterFactory getResultPrinterFactory() {
        return new ApplicationResultPrinterFactory(this.getLog()).withCoverageSummaryReport(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct()).withSurefireReports(this.enableSurefireReports, this.surefireReportsFolder, this.effectiveSystemProperties).withTestOutputReports(Boolean.valueOf(this.redirectTestOutputToFile), this.testOutputDirectory);
    }

    protected ApplicationStructureGenerator getApplicationStructureGenerator() {
        return new MuleApplicationStructureGenerator(this.project.getBasedir().toPath(), Paths.get(this.project.getBuild().getDirectory(), new String[0]));
    }

    protected File getMuleApplicationJsonPath() {
        Path projectBuildDirectoryPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path muleApplicationJsonPath = projectBuildDirectoryPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json");
        return muleApplicationJsonPath.toFile();
    }

    public MuleApplicationModelLoader getMuleApplicationModelLoader() throws MojoExecutionException {
        return super.getMuleApplicationModelLoader().withRuntimeVersion(this.runtimeVersion).withRuntimeProduct(this.runtimeProduct);
    }

    private void saveRunDataToFile(RunResult runResult) {
        this.saveAsJsonDataToFile(this.coverage == null ? new Coverage() : this.coverage, this.coverageConfigDataFile);
        runResult.getApplicationCoverageReport().ifPresent(this::saveCoverageReportDataToFile);
    }

    private void saveCoverageReportDataToFile(ApplicationCoverageReport applicationCoverageReport) {
        this.saveAsJsonDataToFile(applicationCoverageReport, this.coverageReportDataFile);
    }
}

