/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.coverage;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;

public class CoverageLimitsChecker {
    private Log log;
    private Coverage coverageConfiguration;
    private CoverageAuthorizator coverageAuthorizator;
    private ApplicationCoverageReport coverageReport = null;

    public CoverageLimitsChecker(Coverage coverageConfiguration, String runtimeProduct, Log log) {
        Preconditions.checkNotNull((Object)coverageConfiguration, (Object)"The coverage configuration must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)runtimeProduct), (Object)"The runtime product must not be null nor empty");
        Preconditions.checkNotNull((Object)log, (Object)"The log configuration must not be null");
        this.log = log;
        this.coverageConfiguration = coverageConfiguration;
        this.coverageAuthorizator = new CoverageAuthorizator(coverageConfiguration, runtimeProduct);
    }

    public void setCoverageReport(ApplicationCoverageReport coverageReport) {
        this.coverageReport = coverageReport;
    }

    public Boolean failBuild() {
        if (this.isCoverageActivated().booleanValue() && this.coverageConfiguration.getFailBuild().booleanValue()) {
            Preconditions.checkState((this.coverageReport != null ? 1 : 0) != 0, (Object)"No coverage report has been defined");
            return this.failsRequiredApplicationCoverage() || this.failsRequiredResourceCoverage() || this.failsRequiredFlowCoverage();
        }
        this.log.debug((CharSequence)"Coverage is either not activated or not flagged to fail.");
        return false;
    }

    private boolean failsRequiredApplicationCoverage() {
        if (this.coverageConfiguration.getRequiredApplicationCoverage() == -1.0) {
            return false;
        }
        return this.coverageReport.getCoverage() != -1.0 && this.coverageReport.getCoverage() < this.coverageConfiguration.getRequiredApplicationCoverage();
    }

    private boolean failsRequiredResourceCoverage() {
        if (this.coverageConfiguration.getRequiredResourceCoverage() == -1.0) {
            return false;
        }
        return this.coverageReport.getResources().stream().anyMatch(mr -> mr.getCoverage() != -1.0 && mr.getCoverage() < this.coverageConfiguration.getRequiredResourceCoverage());
    }

    private boolean failsRequiredFlowCoverage() {
        if (this.coverageConfiguration.getRequiredFlowCoverage() == -1.0) {
            return false;
        }
        return this.coverageReport.getResources().stream().flatMap(mr -> mr.getFlows().stream()).anyMatch(mf -> mf.getCoverage() != -1.0 && mf.getCoverage() < this.coverageConfiguration.getRequiredFlowCoverage());
    }

    private Boolean isCoverageActivated() {
        return this.coverageAuthorizator.shouldRunCoverage();
    }
}

