/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mojo.exceptions;

import org.apache.maven.plugin.MojoExecutionException;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * <p>
 * Returns Mojo Execution Exceptions with famous quotes
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MojoExecutionExceptionFactory {

  private boolean randomMessages = false;
  private List<String> messages = new ArrayList<>();

  public MojoExecutionExceptionFactory(boolean randomMessages) {
    this.messages = buildMessageList();
    this.randomMessages = randomMessages;
  }

  private List<String> buildMessageList() {
    List<String> messageList = new ArrayList<>();
    messageList.add("[It's a trap]");
    messageList.add("[I see dead code]");
    messageList.add("[Why so serious son?]");
    messageList.add("[You shall not pass]");
    messageList.add("[My precious... bug]");
    messageList.add("[I'm dog chasing bugs]");
    messageList.add("[Hasta la vista, baby]");
    messageList.add("[I'm an agent of chaos]");
    messageList.add("[You choose poooooorly]");
    messageList.add("[Go ahead, make my day]");
    messageList.add("[Elementary, my dear Watson]");
    messageList.add("[Houston, we have a problem]");
    messageList.add("[If you fix it, it will pass]");
    messageList.add("[There's no crying in coding!]");
    messageList.add("[You are gonna need a bigger flow]");
    messageList.add("[Say hello to my little test/fail]");
    messageList.add("[You've failed me for the last time]");
    messageList.add("[Frankly My Dear, I don't give a damn]");
    messageList.add("[If you only new the power of testing]");
    messageList.add("[Help me, Obi-Wan Kenobi. I have a bug]");
    messageList.add("[Do or do not, and you are not doing it]");
    messageList.add("[Talk is cheap and your code is not working]");
    messageList.add("[I love the smell of failure in the morning]");
    messageList.add("[Keep your code close, but your bugs closer]");
    messageList.add("[I'm going to make him a test he can't ignore]");
    messageList.add("[Ah-ta-ta-ta! let's not blow this out of proportion]");
    messageList.add("[I'm not crazy my reality is just different than yours]");
    messageList.add("[You will lose Harry Potter and your friends will die]");
    messageList.add("[Fasten your seat belts. It's going to be a bumpy build]");
    messageList.add("[I will look for you, I will find you, and I will FIX you]");
    messageList.add("[Magic Mirror on the wall, who is the fairest bug of all?]");
    messageList.add("[They may take our lives, but they'll never take our bugs!]");
    messageList.add("[The first rule of Bug Club is: You do not talk about Bug Club]");


    return messageList;
  }

  private String getRandomMessage(List<String> messages) {
    Random randomGenerator = new Random();
    int index = randomGenerator.nextInt(messages.size());
    return messages.get(index);
  }

  public MojoExecutionException buildException(String message, Throwable e) {
    StringBuilder builder = new StringBuilder();
    if (randomMessages) {
      builder.append(getRandomMessage(messages)).append(" - ");
    }

    builder.append(message);
    return new MojoExecutionException(builder.toString(), e);
  }

}
