/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.CoverageAuthorizator;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.TargetRuntime;
import org.mule.munit.plugin.maven.util.BaseApplicationRunConfigurationFactory;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.EmbeddedContainerConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;

public class ApplicationRunConfigurationFactory
extends BaseApplicationRunConfigurationFactory {
    private Coverage coverage;
    private String pluginVersion;
    private boolean shouldRunCoverage;

    public ApplicationRunConfigurationFactory(Log log, String munitTest, String munitTags, Boolean skipAfterFailure, TargetRuntime targetRuntime, WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder, Coverage coverage, String pluginVersion, MavenProject project, MavenSession session) {
        super(log, project.getArtifactId(), munitTest, munitTags, skipAfterFailure, targetRuntime, workingDirectoryGenerator, munitSrcFolder, project, session);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pluginVersion), (Object)"The pluginVersion must not be null nor empty");
        this.coverage = coverage;
        this.pluginVersion = pluginVersion;
        this.shouldRunCoverage = new CoverageAuthorizator(coverage, targetRuntime.getRuntimeProduct()).shouldRunCoverage();
    }

    protected RunConfiguration.RunConfigurationBuilder getRunConfigurationBuilder() throws MojoExecutionException {
        RunConfiguration.RunConfigurationBuilder builder = super.getRunConfigurationBuilder();
        return builder.withCoverageConfiguration(this.buildCoverageConfiguration(this.shouldRunCoverage));
    }

    protected ContainerConfiguration.ContainerConfigurationBuilder getContainerConfigurationBuilder() {
        EmbeddedContainerConfiguration.EmbeddedContainerConfigurationBuilder builder = (EmbeddedContainerConfiguration.EmbeddedContainerConfigurationBuilder)super.getContainerConfigurationBuilder();
        if (this.shouldRunCoverage) {
            String coveragePluginVersion = this.pluginVersion;
            ServerPluginConfiguration coveragePluginConfiguration = this.getCoverageServerPluginConfiguration(coveragePluginVersion);
            builder.withServerPluginConfiguration(coveragePluginConfiguration);
        }
        return builder;
    }

    private CoverageConfiguration buildCoverageConfiguration(Boolean shouldRunCoverage) {
        Set coverageIgnoreFlows = this.coverage != null ? this.coverage.getIgnoreFlows() : Collections.emptySet();
        Set coverageIgnoreFiles = this.coverage != null ? this.coverage.getIgnoreFiles() : Collections.emptySet();
        CoverageConfiguration coverageConfiguration = new CoverageConfiguration.CoverageConfigurationBuilder().withShouldRunCoverage(shouldRunCoverage).withSuitePaths(this.locateMunitTestSuitesToRun()).withIgnoredFiles(coverageIgnoreFiles).withIgnoredFlowNames(coverageIgnoreFlows).build();
        return coverageConfiguration;
    }

    private ServerPluginConfiguration getCoverageServerPluginConfiguration(String coveragePluginVersion) {
        return new ServerPluginConfiguration.ServerPluginConfigurationBuilder().withGroupId("com.mulesoft.munit.plugins").withArtifactId("munit-coverage-plugin").withVersion(coveragePluginVersion).withClassifier("mule-server-plugin").withType("jar").build();
    }
}

