/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import static java.util.Collections.emptySet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * This class define the configuration of the coverage functionality
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class Coverage {

  private Boolean runCoverage = false;

  private Boolean failBuild = false;

  private Double requiredApplicationCoverage = -1.0;
  private Double requiredResourceCoverage = -1.0;
  private Double requiredFlowCoverage = -1.0;

  private Set<String> ignoreFlows = emptySet();
  private Set<String> ignoreFiles = emptySet();

  private List<String> formats = new ArrayList<>();

  public Boolean isRunCoverage() {
    return runCoverage;
  }

  public void setRunCoverage(Boolean runCoverage) {
    this.runCoverage = runCoverage;
  }

  public Boolean getFailBuild() {
    return failBuild;
  }

  public void setFailBuild(Boolean failBuild) {
    this.failBuild = failBuild;
  }

  public Double getRequiredApplicationCoverage() {
    return requiredApplicationCoverage;
  }

  public void setRequiredApplicationCoverage(Double requiredApplicationCoverage) {
    this.requiredApplicationCoverage = requiredApplicationCoverage;
  }

  public Double getRequiredResourceCoverage() {
    return requiredResourceCoverage;
  }

  public void setRequiredResourceCoverage(Double requiredResourceCoverage) {
    this.requiredResourceCoverage = requiredResourceCoverage;
  }

  public Double getRequiredFlowCoverage() {
    return requiredFlowCoverage;
  }

  public void setRequiredFlowCoverage(Double requiredFlowCoverage) {
    this.requiredFlowCoverage = requiredFlowCoverage;
  }

  public List<String> getFormats() {
    return formats;
  }

  public void setFormats(List<String> formats) {
    this.formats = formats;
  }

  public Set<String> getIgnoreFlows() {
    return ignoreFlows;
  }

  public void setIgnoreFlows(Set<String> ignoreFlows) {
    this.ignoreFlows = ignoreFlows;
  }

  public Set<String> getIgnoreFiles() {
    return ignoreFiles;
  }

  public void setIgnoreFiles(Set<String> ignoreFiles) {
    this.ignoreFiles = ignoreFiles;
  }
}
