/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.coverage;

import static com.google.common.base.Preconditions.checkArgument;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import org.mule.munit.Coverage;
import org.mule.munit.plugin.maven.runtime.Product;

/**
 * This class holds the logic to validate if coverage should be run.
 * 
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class CoverageAuthorizator {

  public static final Product MANDATORY_PRODUCT = Product.MULE_EE;
  private final Coverage coverage;
  private final String runtimeProduct;

  public CoverageAuthorizator(Coverage coverage, String runtimeProduct) {
    checkArgument(isNotBlank(runtimeProduct), "The runtime product must not be null nor empty");

    this.coverage = coverage;
    this.runtimeProduct = runtimeProduct;
  }

  /**
   * Validates if coverage should be run
   * 
   * @return false if coverage should not be run
   */
  public Boolean shouldRunCoverage() {
    Boolean shouldRunCoverage =
        coverage != null ? coverage.isRunCoverage() && MANDATORY_PRODUCT.name().equals(runtimeProduct) : false;
    return shouldRunCoverage;
  }
}
