/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
/**
 * This file was automatically generated by the Mule Development Kit
 */
package org.mule.munit;

import org.mule.api.annotations.Category;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;

/**
 * <p>Module to test database connections</p>
 *
 * @author Mulesoft Inc.
 * @author Casal, Javier
 */
@Module(name = "dbserver", schemaVersion = "1.0", minMuleVersion = "3.4.0", friendlyName = "DB Server")
@Category(name = "org.mule.tooling.category.munit.utils", description = "Munit tools")
public class DBServerModule
{

    /**
     * <p>H2 Database name</p>
     */
    @Configurable
    @Placement(tab="General", group = "General", order = 2)
    private String database;

    /**
     * <p>Name of (or path to) the SQL file whose statements will be executed when the database is started</p>
     */
    @Configurable
    @Optional
    @Placement(tab="General", group = "General", order = 3)
    private String sqlFile;

    /**
     * <p>CSV files (separated by semicolon) that creates tables in the database using the file name (without the
     * termination, ".csv") as the table name and its columns as the table columns</p>
     */
    @Configurable
    @Optional
    @Placement(tab="General", group = "General", order = 1)
    private String csv;

    /**
     * <p>Connection parameters (keyword - value pairs separated by semicolon) that specify the database configuration.
     * Example: Key1=Value1;Key2=Value2</p>
     */
    @Configurable
    @Optional
    @Default("")
    @Placement(tab="General", group = "General", order = 4)
    private String connectionStringParameters;

    private DatabaseServer server;

    public DBServerModule() {
    }


    /**
     * <p>Starts the server</p>
     * <p>Executes the correspondent queries if an SQL file has been included in the dbserver configuration</p>
     * <p>Creates the correspondent tables in the database if a CSV file has been included in the dbserver
     * configuration</p>
     * <p/>
     * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:start}
     */
    @Processor
    public void startDbServer()
    {
        server = new DatabaseServer(database, sqlFile, csv, connectionStringParameters);
        server.start();
    }

    /**
     * <p>Executes the SQL query received as parameter</p>
     * <p/>
     * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:execute}
     *
     * @param sql query to be executed
     * @return result of the SQL query received
     */
    @Processor
    public Object execute(String sql)
    {
        return server.execute(sql);
    }


    /**
     * <p>Executes a SQL query</p>
     * <p/>
     * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:executeQuery}
     *
     * @param sql query to be executed
     * @return result of the SQL query in a JSON format.
     */
    @Processor
    public Object executeQuery(String sql)
    {
        return server.executeQuery(sql);
    }

    /**
     * <p>Executes a SQL query</p>
     * <p/>
     * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:validateThat}
     *
     * @param query   query to be executed
     * @param returns Expected value
     */
    @Processor
    public void validateThat(String query, String returns)
    {
        server.validateThat(query, returns);
    }

    /**
     * <p>Stops the server.</p>
     * <p/>
     * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:stop}
     */
    @Processor
    public void stopDbServer()
    {
        if(server != null) {
            server.stop();
        }
    }


    public void setDatabase(String database)
    {
        this.database = database;
    }

    public void setSqlFile(String sqlFile)
    {
        this.sqlFile = sqlFile;
    }

    public void setCsv(String csv)
    {
        this.csv = csv;
    }

    public void setConnectionStringParameters(String connectionStringParameters)
    {
        this.connectionStringParameters = connectionStringParameters;
    }

    public String getDatabase()
    {
        return database;
    }

    public String getSqlFile()
    {
        return sqlFile;
    }

    public String getCsv()
    {
        return csv;
    }

    public String getConnectionStringParameters()
    {
        return connectionStringParameters;
    }
}
