/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.tools.RunScript;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.mule.munit.DatabaseServerException;

public class DatabaseServer {
    private static Logger logger = LogManager.getLogger(DatabaseServer.class);
    private String database;
    private String sqlFile;
    private String csv;
    private Connection connection;
    private String connectionStringParameters;

    public DatabaseServer(String database, String sqlFile, String csv, String connectionStringParameters) {
        this.database = database;
        this.sqlFile = sqlFile;
        this.csv = csv;
        this.connectionStringParameters = connectionStringParameters;
    }

    public void start() {
        try {
            logger.info("Starting database server...");
            this.addJdbcToClassLoader();
            this.sanitizeDatabaseName();
            String connectionString = this.getConnectionString();
            this.connection = DriverManager.getConnection(connectionString);
            this.executeQueriesFromSQLFile(this.connection);
            Statement stmt = this.connection.createStatement();
            this.createTablesFromCsv(stmt);
        }
        catch (Exception e) {
            throw new DatabaseServerException("Could not start the database server", e);
        }
    }

    private void sanitizeDatabaseName() {
        this.database = StringUtils.substringBefore((String)StringUtils.trim((String)this.database), (String)";");
    }

    public Object execute(String sql) {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            return statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error("There has been a problem while executing the SQL statement", (Throwable)e);
            throw new DatabaseServerException("There has been a problem while executing the SQL statement", e);
        }
    }

    public Object executeQuery(String sql) {
        try {
            return this.getMap(sql);
        }
        catch (SQLException e) {
            logger.error("There has been a problem while executing the SQL statement", (Throwable)e);
            throw new DatabaseServerException("There has been a problem while executing the SQL statement", e);
        }
    }

    public void validateThat(String query, String returns) {
        try {
            Writer writerQueryResult = this.getResults(query);
            String expected = returns.replace("\\n", "\n");
            String actual = writerQueryResult.toString().trim();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (ComparisonFailure e) {
            throw new AssertionError((Object)e.getMessage());
        }
        catch (ClassCastException ccException) {
            throw new RuntimeException("The JSON String must always be an array");
        }
        catch (SQLException e) {
            throw new RuntimeException("Invalid Query");
        }
        catch (IOException e) {
            throw new RuntimeException("Could no access to query results");
        }
    }

    public void stop() {
        logger.info("Stopping database server ...");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not stop the database server", e);
        }
    }

    private void addJdbcToClassLoader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName("org.h2.Driver").newInstance();
    }

    private void executeQueriesFromSQLFile(Connection conn) throws SQLException, FileNotFoundException {
        if (this.sqlFile != null) {
            logger.info("Loading " + this.sqlFile + " ...");
            InputStream streamImput = this.getClass().getClassLoader().getResourceAsStream(this.sqlFile);
            if (streamImput != null) {
                RunScript.execute((Connection)conn, (Reader)new InputStreamReader(streamImput));
            } else {
                throw new RuntimeException("The SQL file " + this.sqlFile + " could not be found");
            }
        }
    }

    private void createTablesFromCsv(Statement stmt) {
        if (this.csv != null) {
            logger.info("Loading " + this.csv + " ...");
            String[] tables = this.csv.split(";");
            boolean isCaseSensitive = this.isDatabaseToUpperParameterSet(this.connectionStringParameters);
            for (String table : tables) {
                String tableName = table.replaceAll(".csv", "");
                try {
                    StringBuilder command = new StringBuilder();
                    command.append("CREATE TABLE `" + tableName + "` AS SELECT * FROM CSVREAD('classpath:" + table + "'");
                    if (isCaseSensitive) {
                        command.append(", null, 'caseSensitiveColumnNames=true'");
                    }
                    command.append(");");
                    stmt.execute(command.toString());
                }
                catch (SQLException e) {
                    throw new RuntimeException("Could not create table " + tableName + " from " + table + " : " + e.getCause());
                }
            }
        }
    }

    private boolean isDatabaseToUpperParameterSet(String connectionStringParameters) {
        String[] parameters = StringUtils.split((String)connectionStringParameters, (char)';');
        if (parameters != null) {
            for (String parameter : parameters) {
                if (!StringUtils.containsIgnoreCase((String)parameter, (String)"DATABASE_TO_UPPER") || !StringUtils.containsIgnoreCase((String)parameter, (String)"FALSE")) continue;
                return true;
            }
        }
        return false;
    }

    private List<Map<String, String>> getMap(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        ArrayList<Map<String, String>> jsonArray = new ArrayList<Map<String, String>>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        while (resultSet.next()) {
            HashMap<String, String> jsonObject = new HashMap<String, String>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                jsonObject.put(columnName, String.valueOf(resultSet.getObject(columnName)));
            }
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    private Writer getResults(String sql) throws SQLException, IOException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        StringWriter writer = new StringWriter();
        CSVWriter csvwriter = new CSVWriter((Writer)writer);
        csvwriter.writeAll(resultSet, true);
        return writer;
    }

    private String getConnectionString() {
        String connectionString = "jdbc:h2:mem:" + this.database;
        if (StringUtils.isNotBlank((String)this.connectionStringParameters)) {
            connectionString = connectionString + ";" + this.connectionStringParameters;
        }
        logger.debug("Connection string: " + connectionString);
        return connectionString;
    }
}

