/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import org.mule.config.MuleManifest;
import org.mule.munit.config.DBServerModuleConfigDefinitionParser;
import org.mule.munit.config.ExecuteDefinitionParser;
import org.mule.munit.config.ExecuteQueryDefinitionParser;
import org.mule.munit.config.StartDbServerDefinitionParser;
import org.mule.munit.config.StopDbServerDefinitionParser;
import org.mule.munit.config.ValidateThatDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class DbserverNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(DbserverNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [dbserver] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [dbserver] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new DBServerModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("start-db-server", (BeanDefinitionParser)new StartDbServerDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("start-db-server", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("execute", (BeanDefinitionParser)new ExecuteDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("execute", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("execute-query", (BeanDefinitionParser)new ExecuteQueryDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("execute-query", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("validate-that", (BeanDefinitionParser)new ValidateThatDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("validate-that", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("stop-db-server", (BeanDefinitionParser)new StopDbServerDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("stop-db-server", "@Processor", ex);
        }
    }
}

