/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.exception;

import static org.mule.munit.exception.DatabaseServerErrors.DATABASE_SERVER_ERROR;

import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * Exception for failing database server startup and queries.
 *
 * @since 3.4-M4
 */
public class DatabaseServerException extends ModuleException {

  /**
   *
   */
  private static final long serialVersionUID = 1L;


  public DatabaseServerException(
                                 Throwable cause) {
    super(DATABASE_SERVER_ERROR, cause);
  }

  public DatabaseServerException(I18nMessage message,

                                 Throwable cause) {
    super(message, DATABASE_SERVER_ERROR, cause);
  }

  public DatabaseServerException(String message,
                                 Throwable cause) {
    super(message, DATABASE_SERVER_ERROR, cause);
  }

  public DatabaseServerException(I18nMessage message) {
    super(message, DATABASE_SERVER_ERROR);
  }

  public DatabaseServerException(String message) {
    super(message, DATABASE_SERVER_ERROR);
  }

}
