/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

/**
 * @author Mulesoft Inc.
 */
public class DBServerConnectionProvider implements CachedConnectionProvider<DatabaseServer>, Lifecycle {

  /**
   * <p>
   * H2 Database name
   * </p>
   */
  @Parameter
  @Placement(order = 2)
  private String database;

  /**
   * <p>
   * Name of (or path to) the SQL file whose statements will be executed when the database is started
   * </p>
   */
  @Parameter
  @Optional
  @Placement(order = 3)
  private String sqlFile;

  /**
   * <p>
   * CSV files (separated by semicolon) that creates tables in the database using the file name (without the termination, ".csv")
   * as the table name and its columns as the table columns
   * </p>
   */
  @Parameter
  @Optional
  @Placement(order = 1)
  private String csv;

  /**
   * <p>
   * Connection parameters (keyword - value pairs separated by semicolon) that specify the database configuration. Example:
   * Key1=Value1;Key2=Value2
   * </p>
   */
  @Parameter
  @Optional(defaultValue = StringUtils.EMPTY)
  @Placement(order = 4)
  private String connectionStringParameters;

  private DatabaseServer server;

  @Override
  public DatabaseServer connect() throws ConnectionException {

    return server;
  }

  @Override
  public void disconnect(DatabaseServer databaseServer) {}

  @Override
  public ConnectionValidationResult validate(DatabaseServer databaseServer) {
    return ConnectionValidationResult.success();
  }

  @Override
  public void dispose() {

  }

  @Override
  public void initialise() throws InitialisationException {

  }

  @Override
  public void start() throws MuleException {
    server = new DatabaseServer(database, sqlFile, csv, connectionStringParameters);
    server.start();
  }

  @Override
  public void stop() throws MuleException {
    if (server != null) {
      server.stop();
    }
  }
}
