/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import java.util.List;
import java.util.Map;

import org.mule.munit.exception.DatabaseServerErrorTypeProvider;
import org.mule.munit.exception.DatabaseServerException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;


/**
 * <p>
 * Operations of the DBServer
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class DatabaseServerOperations {

  /**
   * <p>
   * Executes the SQL query received as parameter
   * </p>
   * <p/>
   * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:execute}
   *
   * @param sql query to be executed
   * @return result of the SQL query received
   */
  @Throws(DatabaseServerErrorTypeProvider.class)
  public Boolean execute(String sql, @Connection DatabaseServer server) throws DatabaseServerException {
    return server.execute(sql);
  }


  /**
   * <p>
   * Executes a SQL query
   * </p>
   * <p/>
   * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:executeQuery}
   *
   * @param sql query to be executed
   * @return result of the SQL query in a JSON format.
   */
  @Throws(DatabaseServerErrorTypeProvider.class)
  public List<Map<String, String>> executeQuery(String sql, @Connection DatabaseServer server) throws DatabaseServerException {
    return server.executeQuery(sql);
  }

  /**
   * <p>
   * Executes a SQL query
   * </p>
   * <p/>
   * {@sample.xml ../../../doc/DBServer-connector.xml.sample dbserver:validateThat}
   *
   * @param query query to be executed
   * @param returns Expected value
   */
  @Throws(DatabaseServerErrorTypeProvider.class)
  public void validateThat(String query, String returns, @Connection DatabaseServer server) throws DatabaseServerException {
    server.validateThat(query, returns);
  }
}
