/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.exception;

import static org.mule.munit.exception.DatabaseServerErrors.DATABASE_SERVER_ERROR;

import org.mule.munit.DatabaseServerOperations;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.HashSet;
import java.util.Set;

/**
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class DatabaseServerErrorTypeProvider implements ErrorTypeProvider {

  /**
   * @return all the error types that can be thrown by the {@link DatabaseServerOperations}.
   */
  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    Set<ErrorTypeDefinition> errorTypeDefinitions = new HashSet();
    errorTypeDefinitions.add(DATABASE_SERVER_ERROR);
    return errorTypeDefinitions;
  }
}
