/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.*;
import org.apache.ftpserver.listener.ListenerFactory;

/**
 * <p>Wrapper of the FTP Server</p>
 *
 * @author Mulesoft Inc.
 */
public class FTPServer extends Server
{
    private FtpServer server;

    public static Server instance(int port, String username, String password, boolean anonymous, String homeDir)
    {
        FTPServer ftpServer = new FTPServer();
        ftpServer.initialize(port, username, password, anonymous, homeDir);
        return ftpServer;
    }

    @Override
    void initialize(int port, String username, String password, boolean anonymous, String homeDir)
    {
        FtpServerFactory serverFactory = new FtpServerFactory();

        ListenerFactory factory = new ListenerFactory();

        factory.setPort(port);
        serverFactory.setConnectionConfig(new MockConnectionConfig(anonymous));
        serverFactory.setUserManager(new MockUserManagerAuthenticator(username, password, anonymous, getAdaptedPath(homeDir)));

        serverFactory.addListener("default", factory.createListener());

        server = serverFactory.createServer();

    }

    private String getAdaptedPath(String homeDir) {
        return (StringUtils.isBlank(homeDir) ? "/" : homeDir);
    }

    @Override
    void start()
    {
        try
        {
            server.start();
        }
        catch (FtpException e)
        {
            throw new RuntimeException("Could not start FTP server", e);
        }
    }

    @Override
    void stop()
    {
        server.stop();
    }

    private class MockConnectionConfig implements ConnectionConfig {

        private boolean anonymous;

        public MockConnectionConfig(boolean anonymous) {
            this.anonymous = anonymous;
        }

        public int getMaxThreads() { return 0; }

        public int getMaxLoginFailures() {
            return 0;
        }

        public int getLoginFailureDelay() {
            return 0;
        }

        public int getMaxAnonymousLogins() {
            return 100;
        }

        public int getMaxLogins() {
            return 0;
        }

        public boolean isAnonymousLoginEnabled() {
            return anonymous;
        }
    }
}
