/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.io.IOException;
import java.security.Security;
import java.util.Arrays;

/**
 * <p>SFTP Wrapper</p>
 *
 * @author Mulesoft Inc.
 */
public class SFTPServer extends Server {

    private SshServer sshd;

    public static Server instance(int port, String username, String password, boolean anonymous, String homeDir) {
        SFTPServer sftpServer = new SFTPServer();
        sftpServer.initialize(port, username, password, anonymous, homeDir);
        return sftpServer;
    }

    @Override
    public void initialize(int port, String username, String password, boolean anonymous, String homeDir) {
        Security.addProvider(new BouncyCastleProvider());
        sshd = SshServer.setUpDefaultServer();
        sshd.setPort(port);

        sshd.setFileSystemFactory(new VirtualFileSystemFactory(getAdaptedPath(homeDir)));
        StreamKeyPairProvider fileKeyPairProvider = new StreamKeyPairProvider();
        sshd.setKeyPairProvider(fileKeyPairProvider);
        SftpSubsystemFactory factory = new SftpSubsystemFactory();

        sshd.setSubsystemFactories(Arrays.<NamedFactory<Command>>asList(factory));
        sshd.setCommandFactory(new ScpCommandFactory());
        sshd.setShellFactory(new ProcessShellFactory());
        sshd.setPasswordAuthenticator(new MockUserManagerAuthenticator(username, password, anonymous, getAdaptedPath(homeDir)));
    }

    private String getAdaptedPath(String homeDir) {
        return (homeDir == null ? "/" : homeDir);
    }

    @Override
    public void start() {
        try {
            sshd.start();
        } catch (IOException e) {
            throw new RuntimeException("Could not start the server", e);
        }
    }

    @Override
    public void stop() {
        try {
            sshd.stop();
        } catch (IOException e) {
            throw new RuntimeException("Could not stop the server", e);
        }
        sshd = null;
    }


}
