/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Mock User for testing</p>
 *
 * @author Mulesoft Inc.
 */
public class MockUser extends BaseUser {
    private String name;
    private String password;

    public MockUser(String name, String password) {
        this.name = name;
        this.password = password;
    }

    @Override
    public String getName() {
        return this.name;
    }
    @Override
    public String getPassword() {
        return this.password;
    }
    @Override
    public List<Authority> getAuthorities() {
        return new ArrayList<Authority>();
    }
    @Override
    public List<Authority> getAuthorities(Class<? extends Authority> aClass) {
        return new ArrayList<Authority>();
    }
    @Override
    public AuthorizationRequest authorize(AuthorizationRequest authorizationRequest) {
        return new TransferRateRequest() {
        };
    }
    @Override
    public int getMaxIdleTime() {
        return 5;
    }
    @Override
    public boolean getEnabled() {
        return true;
    }
}
