/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit;

import java.io.File;
import java.io.FilenameFilter;

import static org.junit.Assert.assertTrue;

/**
 * <p>Implementation of the FTP server</p>
 *
 * @author Mulesoft Inc.
 */
public abstract class Server {

    abstract void initialize(int port, String username, String password, boolean anonymous, String homeDir);

    abstract void start();

    abstract void stop();

    public void containsFiles(String file, String path) {
        File[] filteredFiles = containsFilteredFiles(file, path);
        if(filteredFiles == null) {
            throw new RuntimeException("The path to the file does not exist or an I/O error has occurred");
        }
        assertTrue("The file was not found in the folder", filteredFiles.length > 0);
    }

    private File[] containsFilteredFiles(final String fileName, String path) {
        return new File(path).listFiles(new FilenameFilter() {
            public boolean accept(File file, String name) {
                return name.startsWith(fileName);
            }
        });
    }

    public void remove(String path) {
        new File(path).delete();
    }
}
