
package org.mule.munit.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.munit.FTPServerModule;
import org.mule.munit.adapters.FTPServerModuleProcessAdapter;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * ContainsFilesMessageProcessor invokes the {@link org.mule.munit.FTPServerModule#containsFiles(java.lang.String, java.lang.String)} method in {@link FTPServerModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.5.3", date = "2018-07-03T09:28:38-04:00", comments = "Build UNNAMED.2049.ec39f2b")
public class ContainsFilesMessageProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor
{

    protected Object file;
    protected String _fileType;
    protected Object path;
    protected String _pathType;

    public ContainsFilesMessageProcessor(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    @Override
    public void start()
        throws MuleException
    {
        super.start();
    }

    @Override
    public void stop()
        throws MuleException
    {
        super.stop();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /**
     * Sets path
     * 
     * @param value Value to set
     */
    public void setPath(Object value) {
        this.path = value;
    }

    /**
     * Sets file
     * 
     * @param value Value to set
     */
    public void setFile(Object value) {
        this.file = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws Exception
     */
    public MuleEvent doProcess(final MuleEvent event)
        throws Exception
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(FTPServerModuleProcessAdapter.class, true, event);
            final String _transformedFile = ((String) evaluateAndTransform(getMuleContext(), event, ContainsFilesMessageProcessor.class.getDeclaredField("_fileType").getGenericType(), null, file));
            final String _transformedPath = ((String) evaluateAndTransform(getMuleContext(), event, ContainsFilesMessageProcessor.class.getDeclaredField("_pathType").getGenericType(), null, path));
            final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((FTPServerModule) object).containsFiles(_transformedFile, _transformedPath);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (Exception e) {
            throw e;
        }
    }

}
