/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mule.munit.MockUserManagerAuthenticator;
import org.mule.munit.Server;
import org.mule.munit.StreamKeyPairProvider;

public class SFTPServer
extends Server {
    private SshServer sshd;

    public static Server instance(int port, String username, String password, boolean anonymous, String homeDir) {
        SFTPServer sftpServer = new SFTPServer();
        sftpServer.initialize(port, username, password, anonymous, homeDir);
        return sftpServer;
    }

    @Override
    public void initialize(int port, String username, String password, boolean anonymous, String homeDir) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(port);
        this.sshd.setFileSystemFactory((FileSystemFactory)new VirtualFileSystemFactory(this.getAdaptedPath(homeDir)));
        StreamKeyPairProvider fileKeyPairProvider = new StreamKeyPairProvider();
        this.sshd.setKeyPairProvider((KeyPairProvider)fileKeyPairProvider);
        SftpSubsystemFactory factory = new SftpSubsystemFactory();
        this.sshd.setSubsystemFactories(Arrays.asList(factory));
        this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshd.setShellFactory((Factory)new ProcessShellFactory());
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)new MockUserManagerAuthenticator(username, password, anonymous, this.getAdaptedPath(homeDir)));
    }

    private String getAdaptedPath(String homeDir) {
        return homeDir == null ? "/" : homeDir;
    }

    @Override
    public void start() {
        try {
            this.sshd.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start the server", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.sshd.stop();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not stop the server", e);
        }
        this.sshd = null;
    }
}

