/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

public class AgentClient
extends AbstractAgentProxy
implements Runnable {
    private final String authSocket;
    private final long pool;
    private final long handle;
    private final Buffer receiveBuffer;
    private final Queue<Buffer> messages;
    private Future<?> pumper;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentClient(String authSocket) throws IOException {
        this(authSocket, null, false);
    }

    public AgentClient(String authSocket, ExecutorService executor, boolean shutdownOnExit) throws IOException {
        this.authSocket = authSocket;
        this.setExecutorService(executor == null ? ThreadUtils.newSingleThreadExecutor("AgentClient[" + authSocket + "]") : executor);
        this.setShutdownOnExit(executor == null ? true : shutdownOnExit);
        try {
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            int result = Local.connect((long)this.handle, (long)0L);
            if (result != 0) {
                this.throwException(result);
            }
            this.receiveBuffer = new ByteArrayBuffer();
            this.messages = new ArrayBlockingQueue<Buffer>(10);
            ExecutorService service = this.getExecutorService();
            this.pumper = service.submit(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void run() {
        try {
            byte[] buf = new byte[1024];
            while (this.isOpen()) {
                int result = Socket.recv((long)this.handle, (byte[])buf, (int)0, (int)buf.length);
                if (result < 0) {
                    this.throwException(result);
                }
                this.messageReceived(new ByteArrayBuffer(buf, 0, result));
            }
        }
        catch (Exception e) {
            if (this.isOpen()) {
                this.log.warn(e.getClass().getSimpleName() + " while still open: " + e.getMessage());
            }
        }
        finally {
            block15: {
                try {
                    this.close();
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block15;
                    this.log.debug(e.getClass().getSimpleName() + " while closing: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(Buffer buffer) throws Exception {
        ByteArrayBuffer message = null;
        Object object = this.receiveBuffer;
        synchronized (object) {
            this.receiveBuffer.putBuffer(buffer);
            if (this.receiveBuffer.available() >= 4) {
                int rpos = this.receiveBuffer.rpos();
                int len = this.receiveBuffer.getInt();
                this.receiveBuffer.rpos(rpos);
                if (this.receiveBuffer.available() >= 4 + len) {
                    message = new ByteArrayBuffer(this.receiveBuffer.getBytes());
                    this.receiveBuffer.compact();
                }
            }
        }
        if (message != null) {
            object = this.messages;
            synchronized (object) {
                this.messages.offer(message);
                this.messages.notifyAll();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            Socket.close((long)this.handle);
        }
        if (this.pumper != null && this.isShutdownOnExit() && !this.pumper.isDone()) {
            this.pumper.cancel(true);
        }
        super.close();
    }

    @Override
    protected synchronized Buffer request(Buffer buffer) throws IOException {
        int wpos = buffer.wpos();
        buffer.wpos(0);
        buffer.putInt(wpos - 4);
        buffer.wpos(wpos);
        Queue<Buffer> queue = this.messages;
        synchronized (queue) {
            try {
                int result = Socket.send((long)this.handle, (byte[])buffer.array(), (int)buffer.rpos(), (int)buffer.available());
                if (result < 0) {
                    this.throwException(result);
                }
                if (this.messages.isEmpty()) {
                    this.messages.wait();
                }
                return this.messages.poll();
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException(this.authSocket + ": Interrupted while polling for messages").initCause(e);
            }
        }
    }

    private void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

