/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class TcpipClientChannel
extends AbstractClientChannel {
    private final Type typeEnum;
    private final IoSession serverSession;
    private final SshdSocketAddress remote;

    public TcpipClientChannel(Type type, IoSession serverSession, SshdSocketAddress remote) {
        super(type == Type.Direct ? "direct-tcpip" : "forwarded-tcpip");
        this.typeEnum = type;
        this.serverSession = serverSession;
        this.remote = remote;
    }

    public OpenFuture getOpenFuture() {
        return this.openFuture;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        InetSocketAddress dst;
        InetSocketAddress src;
        switch (this.typeEnum) {
            case Direct: {
                src = (InetSocketAddress)this.serverSession.getRemoteAddress();
                dst = this.remote.toInetSocketAddress();
                break;
            }
            case Forwarded: {
                src = (InetSocketAddress)this.serverSession.getRemoteAddress();
                dst = (InetSocketAddress)this.serverSession.getLocalAddress();
                break;
            }
            default: {
                throw new SshException("Unknown client channel type: " + (Object)((Object)this.typeEnum));
            }
        }
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(this.lock);
        this.log.debug("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this);
        Buffer buffer = this.session.createBuffer((byte)90);
        buffer.putString(this.type);
        buffer.putInt(this.id);
        buffer.putInt(this.localWindow.getSize());
        buffer.putInt(this.localWindow.getPacketSize());
        buffer.putString(dst.getAddress().getHostAddress());
        buffer.putInt(dst.getPort());
        buffer.putString(src.getAddress().getHostAddress());
        buffer.putInt(src.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (this.streaming == ClientChannel.Streaming.Async) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
        ByteArrayBuffer buf = new ByteArrayBuffer(data, off, len);
        buf = new ByteArrayBuffer(buf.getCompactData());
        this.localWindow.consumeAndCheck(len);
        this.serverSession.write(buf);
    }

    public static enum Type {
        Direct,
        Forwarded;

    }
}

