/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.AbstractIoServiceFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.io.nio2.Nio2Connector;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class Nio2ServiceFactory
extends AbstractIoServiceFactory {
    private final AsynchronousChannelGroup group;

    public Nio2ServiceFactory(FactoryManager factoryManager, ExecutorService service, boolean shutdownOnExit) {
        super(factoryManager, service == null ? ThreadUtils.newFixedThreadPool(factoryManager.toString() + "-nio2", Nio2ServiceFactory.getNioWorkers(factoryManager)) : service, service == null || shutdownOnExit);
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(ThreadUtils.protectExecutorServiceShutdown(this.getExecutorService(), this.isShutdownOnExit()));
        }
        catch (IOException e) {
            this.log.warn("Failed (" + e.getClass().getSimpleName() + " to start async. channel group: " + e.getMessage(), (Throwable)e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    public IoConnector createConnector(IoHandler handler) {
        return new Nio2Connector(this.getFactoryManager(), handler, this.group);
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler handler) {
        return new Nio2Acceptor(this.getFactoryManager(), handler, this.group);
    }

    @Override
    protected void doCloseImmediately() {
        try {
            if (!this.group.isShutdown()) {
                this.log.debug("Shutdown group");
                this.group.shutdownNow();
                if (this.isShutdownOnExit()) {
                    if (this.group.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.log.debug("Group successfully shut down");
                    } else {
                        this.log.debug("Not all group tasks terminated");
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Exception caught while closing channel group", (Throwable)e);
        }
        finally {
            super.doCloseImmediately();
        }
    }
}

