/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.io.IoUtils;

public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider {
    public static final String DEFAULT_ALGORITHM = "DSA";
    public static final boolean DEFAULT_ALLOWED_TO_OVERWRITE = true;
    private Path path;
    private String algorithm = "DSA";
    private int keySize;
    private AlgorithmParameterSpec keySpec;
    private KeyPair keyPair;
    private boolean overwriteAllowed = true;

    protected AbstractGeneratorHostKeyProvider() {
    }

    public Path getPath() {
        return this.path;
    }

    public void setFile(File file) {
        this.setPath(file == null ? null : file.toPath());
    }

    public void setPath(Path path) {
        this.path = path == null ? null : path.toAbsolutePath();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public AlgorithmParameterSpec getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(AlgorithmParameterSpec keySpec) {
        this.keySpec = keySpec;
    }

    public boolean isOverwriteAllowed() {
        return this.overwriteAllowed;
    }

    public void setOverwriteAllowed(boolean overwriteAllowed) {
        this.overwriteAllowed = overwriteAllowed;
    }

    @Override
    public synchronized Iterable<KeyPair> loadKeys() {
        LinkOption[] options;
        Path keyPath = this.getPath();
        if (this.keyPair == null && keyPath != null && Files.exists(keyPath, options = IoUtils.getLinkOptions(false)) && Files.isRegularFile(keyPath, options)) {
            try {
                this.keyPair = this.readKeyPair(keyPath, IoUtils.EMPTY_OPEN_OPTIONS);
            }
            catch (Exception e) {
                this.log.warn("Failed (" + e.getClass().getSimpleName() + ")" + " to load from " + keyPath + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.keyPair == null) {
            String alg = this.getAlgorithm();
            try {
                this.keyPair = this.generateKeyPair(alg);
            }
            catch (Exception e) {
                this.log.warn("Failed (" + e.getClass().getSimpleName() + ")" + " to generate " + alg + " keys: " + e.getMessage(), (Throwable)e);
            }
            if (this.keyPair != null && keyPath != null) {
                try {
                    this.writeKeyPair(this.keyPair, keyPath, new OpenOption[0]);
                }
                catch (Exception e) {
                    this.log.warn("Failed (" + e.getClass().getSimpleName() + ")" + " to write to " + keyPath + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.keyPair == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.keyPair);
    }

    protected KeyPair readKeyPair(Path keyPath, OpenOption ... options) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(keyPath, options);){
            KeyPair keyPair = this.doReadKeyPair(keyPath.toString(), inputStream);
            return keyPair;
        }
    }

    protected abstract KeyPair doReadKeyPair(String var1, InputStream var2) throws IOException, GeneralSecurityException;

    protected void writeKeyPair(KeyPair kp, Path keyPath, OpenOption ... options) throws IOException, GeneralSecurityException {
        if (!Files.exists(keyPath, new LinkOption[0]) || this.isOverwriteAllowed()) {
            try (OutputStream os = Files.newOutputStream(keyPath, options);){
                this.doWriteKeyPair(keyPath.toString(), kp, os);
            }
            catch (Exception e) {
                this.log.warn("Unable to write key {}: {}", (Object)this.path, (Object)e);
            }
        } else {
            this.log.error("Overwriting key ({}) is disabled: using throwaway {}", (Object)keyPath, (Object)kp);
        }
    }

    protected abstract void doWriteKeyPair(String var1, KeyPair var2, OutputStream var3) throws IOException, GeneralSecurityException;

    protected KeyPair generateKeyPair(String algorithm) throws GeneralSecurityException {
        KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator(algorithm);
        if (this.keySpec != null) {
            generator.initialize(this.keySpec);
            this.log.info("generateKeyPair(" + algorithm + ") generating host key - spec=" + this.keySpec.getClass().getSimpleName());
        } else if (this.keySize != 0) {
            generator.initialize(this.keySize);
            this.log.info("generateKeyPair(" + algorithm + ") generating host key - size=" + this.keySize);
        }
        return generator.generateKeyPair();
    }
}

