/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.util.Base64;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class PublicKeyEntry
implements Serializable {
    public static final char COMMENT_CHAR = '#';
    public static final String STD_KEYFILE_FOLDER_NAME = ".ssh";
    private static final long serialVersionUID = -585506072687602760L;
    private String keyType;
    private byte[] keyData;

    public PublicKeyEntry() {
    }

    public PublicKeyEntry(String keyType, byte ... keyData) {
        this.keyType = keyType;
        this.keyData = keyData;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String value) {
        this.keyType = value;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    public void setKeyData(byte[] value) {
        this.keyData = value;
    }

    public PublicKey resolvePublicKey() throws IOException, GeneralSecurityException {
        String kt = this.getKeyType();
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(kt);
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder registered for key type=" + kt);
        }
        byte[] data = this.getKeyData();
        Object key = decoder.decodePublicKey(data);
        if (key == null) {
            throw new InvalidKeyException("No key of type=" + kt + " decoded for data=" + BufferUtils.printHex(':', data));
        }
        return key;
    }

    public PublicKey appendPublicKey(Appendable sb) throws IOException, GeneralSecurityException {
        PublicKey key = this.resolvePublicKey();
        PublicKeyEntry.appendPublicKeyEntry(sb, key);
        return key;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKeyType()) + Arrays.hashCode(this.getKeyData());
    }

    protected boolean isEquivalent(PublicKeyEntry e) {
        if (this == e) {
            return true;
        }
        return Objects.equals(this.getKeyType(), e.getKeyType()) && Arrays.equals(this.getKeyData(), e.getKeyData());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isEquivalent((PublicKeyEntry)obj);
    }

    public String toString() {
        byte[] data = this.getKeyData();
        return this.getKeyType() + " " + (GenericUtils.isEmpty(data) ? "<no-key>" : Base64.encodeToString(data));
    }

    public static final PublicKeyEntry parsePublicKeyEntry(String data) throws IllegalArgumentException {
        if (GenericUtils.isEmpty(data)) {
            return null;
        }
        return PublicKeyEntry.parsePublicKeyEntry(new PublicKeyEntry(), data);
    }

    public static final <E extends PublicKeyEntry> E parsePublicKeyEntry(E entry, String data) throws IllegalArgumentException {
        if (GenericUtils.isEmpty(data) || entry == null) {
            return entry;
        }
        int startPos = data.indexOf(32);
        if (startPos <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + data);
        }
        int endPos = data.indexOf(32, startPos + 1);
        if (endPos <= startPos) {
            endPos = data.length();
        }
        String keyType = data.substring(0, startPos);
        String b64Data = data.substring(startPos + 1, endPos).trim();
        byte[] keyData = Base64.decodeString(b64Data);
        if (GenericUtils.isEmpty(keyData)) {
            throw new IllegalArgumentException("Bad format (no BASE64 key data): " + data);
        }
        entry.setKeyType(keyType);
        entry.setKeyData(keyData);
        return entry;
    }

    public static String toString(PublicKey key) throws IllegalArgumentException {
        try {
            return PublicKeyEntry.appendPublicKeyEntry(new StringBuilder(127), key).toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed (" + e.getClass().getSimpleName() + ") to encode: " + e.getMessage(), e);
        }
    }

    public static <A extends Appendable> A appendPublicKeyEntry(A sb, PublicKey key) throws IOException {
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(key);
        if (decoder == null) {
            throw new StreamCorruptedException("Cannot retrived decoder for key=" + key.getAlgorithm());
        }
        try (ByteArrayOutputStream s = new ByteArrayOutputStream(127);){
            String keyType = decoder.encodePublicKey(s, key);
            byte[] bytes = s.toByteArray();
            String b64Data = Base64.encodeToString(bytes);
            sb.append(keyType).append(' ').append(b64Data);
        }
        return sb;
    }

    public static File getDefaultKeysFolder() {
        return LazyDefaultKeysFolderHolder.FOLDER;
    }

    private static final class LazyDefaultKeysFolderHolder {
        private static final File FOLDER = new File(System.getProperty("user.home") + File.separator + ".ssh");

        private LazyDefaultKeysFolderHolder() {
        }
    }
}

