/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.AbstractConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ClientConnectionService
extends AbstractConnectionService {
    public ClientConnectionService(Session s) throws SshException {
        super(s);
        ValidateUtils.checkTrue(s instanceof ClientSession, "Client side service used on server side");
    }

    @Override
    public void start() {
        if (!((ClientSession)((Object)this.session)).isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        this.startHeartBeat();
    }

    protected void startHeartBeat() {
        long interval = FactoryManagerUtils.getLongProperty(this.session, "hearbeat-interval", 0L);
        if (interval > 0L) {
            FactoryManager manager = this.session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            service.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ClientConnectionService.this.sendHeartBeat();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat - started at interval={}", (Object)interval);
            }
        }
    }

    protected void sendHeartBeat() {
        String request = FactoryManagerUtils.getStringProperty(this.session, "heartbeat-request", "keepalive@sshd.apache.org");
        try {
            Buffer buf = this.session.createBuffer((byte)80);
            buf.putString(request);
            buf.putBoolean(false);
            this.session.writePacket(buf);
        }
        catch (IOException e) {
            this.log.info("Error sending keepalive message=" + request, (Throwable)e);
        }
    }

    @Override
    public String initAgentForward() throws IOException {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public String createX11Display(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        throw new IllegalStateException("Server side operation");
    }
}

