/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Set;
import org.apache.sshd.common.scp.ScpSourceStreamResolver;
import org.apache.sshd.common.scp.ScpTimestamp;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class LocalFileScpSourceStreamResolver
extends AbstractLoggingBean
implements ScpSourceStreamResolver {
    private final Path path;
    private final Path name;
    private final Set<PosixFilePermission> perms;
    private final long size;
    private final ScpTimestamp time;

    public LocalFileScpSourceStreamResolver(Path path) throws IOException {
        this.path = ValidateUtils.checkNotNull(path, "No path specified");
        this.name = path.getFileName();
        this.perms = IoUtils.getPermissions(path, new LinkOption[0]);
        BasicFileAttributes basic = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        this.size = basic.size();
        this.time = new ScpTimestamp(basic.lastModifiedTime().toMillis(), basic.lastAccessTime().toMillis());
    }

    @Override
    public String getFileName() throws IOException {
        return this.name.toString();
    }

    @Override
    public Collection<PosixFilePermission> getPermissions() throws IOException {
        return this.perms;
    }

    @Override
    public ScpTimestamp getTimestamp() throws IOException {
        return this.time;
    }

    @Override
    public long getSize() throws IOException {
        return this.size;
    }

    @Override
    public Path getEventListenerFilePath() {
        return this.path;
    }

    @Override
    public InputStream resolveSourceStream() throws IOException {
        return Files.newInputStream(this.getEventListenerFilePath(), new OpenOption[0]);
    }

    public String toString() {
        return String.valueOf(this.getEventListenerFilePath());
    }
}

