/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;

public class BaseCipher
implements Cipher {
    protected final int ivsize;
    protected final int bsize;
    protected final String algorithm;
    protected final String transformation;
    protected javax.crypto.Cipher cipher;

    public BaseCipher(int ivsize, int bsize, String algorithm, String transformation) {
        this.ivsize = ivsize;
        this.bsize = bsize;
        this.algorithm = algorithm;
        this.transformation = transformation;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
        key = BaseCipher.resize(key, this.bsize);
        iv = BaseCipher.resize(iv, this.ivsize);
        try {
            this.cipher = SecurityUtils.getCipher(this.transformation);
            this.cipher.init(mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)new SecretKeySpec(key, this.algorithm), new IvParameterSpec(iv));
        }
        catch (Exception e) {
            this.cipher = null;
            throw new SshException("Unable to initialize cipher " + this, (Throwable)e);
        }
    }

    @Override
    public void update(byte[] input) throws Exception {
        this.update(input, 0, GenericUtils.length(input));
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        this.cipher.update(input, inputOffset, inputLen, input, inputOffset);
    }

    protected static byte[] resize(byte[] data, int size) {
        if (data.length > size) {
            byte[] tmp = new byte[size];
            System.arraycopy(data, 0, tmp, 0, size);
            data = tmp;
        }
        return data;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.algorithm + "," + this.ivsize + "," + this.bsize + "," + this.transformation + "]";
    }
}

