/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.CloseableUtils;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    public static final int DEFAULT_BACKLOG = 0;
    private final Map<SocketAddress, AsynchronousServerSocketChannel> channels = new ConcurrentHashMap<SocketAddress, AsynchronousServerSocketChannel>();
    private int backlog = 0;

    public Nio2Acceptor(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
        this.backlog = FactoryManagerUtils.getIntProperty(manager, "socket-backlog", 0);
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        for (SocketAddress socketAddress : addresses) {
            this.log.debug("Binding Nio2Acceptor to address {}", (Object)socketAddress);
            AsynchronousServerSocketChannel socket = AsynchronousServerSocketChannel.open(this.group);
            this.setOption(socket, "socket-keepalive", StandardSocketOptions.SO_KEEPALIVE, null);
            this.setOption(socket, "socket-linger", StandardSocketOptions.SO_LINGER, null);
            this.setOption(socket, "socket-rcvbuf", StandardSocketOptions.SO_RCVBUF, null);
            this.setOption(socket, "socket-reuseaddr", StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
            this.setOption(socket, "socket-sndbuf", StandardSocketOptions.SO_SNDBUF, null);
            this.setOption(socket, "tcp-nodelay", StandardSocketOptions.TCP_NODELAY, null);
            socket.bind(socketAddress, this.backlog);
            SocketAddress local = socket.getLocalAddress();
            this.channels.put(local, socket);
            socket.accept(local, new AcceptCompletionHandler(socket));
        }
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.bind(Collections.singleton(address));
    }

    @Override
    public void unbind() {
        this.log.debug("Unbinding");
        this.unbind(this.getBoundAddresses());
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        for (SocketAddress socketAddress : addresses) {
            AsynchronousServerSocketChannel channel = this.channels.remove(socketAddress);
            if (channel != null) {
                try {
                    this.log.trace("unbind({})", (Object)socketAddress);
                    channel.close();
                }
                catch (IOException e) {
                    this.log.warn("Error unbinding channel for " + socketAddress, (Throwable)e);
                }
                continue;
            }
            this.log.trace("No active channel to unbind {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress address) {
        this.unbind(Collections.singleton(address));
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.channels.keySet());
    }

    @Override
    public CloseFuture close(boolean immediately) {
        this.unbind();
        return super.close(immediately);
    }

    @Override
    public void doCloseImmediately() {
        for (SocketAddress address : this.channels.keySet()) {
            try {
                this.channels.get(address).close();
            }
            catch (IOException e) {
                this.log.debug("Exception caught while closing channel", (Throwable)e);
            }
        }
        super.doCloseImmediately();
    }

    class AcceptCompletionHandler
    extends Nio2CompletionHandler<AsynchronousSocketChannel, SocketAddress> {
        private final AsynchronousServerSocketChannel socket;

        AcceptCompletionHandler(AsynchronousServerSocketChannel socket) {
            this.socket = socket;
        }

        @Override
        protected void onCompleted(AsynchronousSocketChannel result, SocketAddress address) {
            block7: {
                if (!Nio2Acceptor.this.channels.containsKey(address)) {
                    return;
                }
                CloseableUtils.IoBaseCloseable session = null;
                try {
                    session = new Nio2Session(Nio2Acceptor.this, Nio2Acceptor.this.manager, Nio2Acceptor.this.handler, result);
                    Nio2Acceptor.this.handler.sessionCreated((IoSession)((Object)session));
                    Nio2Acceptor.this.sessions.put(((Nio2Session)session).getId(), session);
                    ((Nio2Session)session).startReading();
                }
                catch (Throwable exc) {
                    this.failed(exc, address);
                    if (session == null) break block7;
                    try {
                        session.close();
                    }
                    catch (Throwable t) {
                        Nio2Acceptor.this.log.warn("Failed (" + t.getClass().getSimpleName() + ")" + " to close accepted connection from " + address + ": " + t.getMessage(), t);
                    }
                }
            }
            try {
                this.socket.accept(address, this);
            }
            catch (Throwable exc) {
                this.failed(exc, address);
            }
        }

        @Override
        protected void onFailed(Throwable exc, SocketAddress address) {
            if (Nio2Acceptor.this.channels.containsKey(address) && !Nio2Acceptor.this.disposing.get()) {
                Nio2Acceptor.this.log.warn("Caught " + exc.getClass().getSimpleName() + " while accepting incoming connection from " + address + ": " + exc.getMessage(), exc);
            }
        }
    }
}

