/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String KB_INTERACTIVE_NAME_PROP = "kb-interactive-name";
    public static final String DEFAULT_KB_INTERACTIVE_NAME = "Password authentication";
    public static final String KB_INTERACTIVE_INSTRUCTION_PROP = "kb-interactive-instruction";
    public static final String DEFAULT_KB_INTERACTIVE_INSTRUCTION = "";
    public static final String KB_INTERACTIVE_LANG_PROP = "kb-interactive-language";
    public static final String DEFAULT_KB_INTERACTIVE_LANG = "en-US";
    public static final String KB_INTERACTIVE_PROMPT_PROP = "kb-interactive-prompt";
    public static final String DEFAULT_KB_INTERACTIVE_PROMPT = "Password: ";
    public static final String KB_INTERACTIVE_ECHO_PROMPT_PROP = "kb-interactive-echo-prompt";
    public static final boolean DEFAULT_KB_INTERACTIVE_ECHO_PROMPT = false;

    @Override
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        if (init) {
            buffer = this.session.createBuffer((byte)60);
            buffer.putString(this.getInteractionName());
            buffer.putString(this.getInteractionInstruction());
            buffer.putString(this.getInteractionLanguage());
            buffer.putInt(1L);
            buffer.putString(this.getInteractionPrompt());
            buffer.putBoolean(this.isInteractionPromptEchoEnabled());
            this.session.writePacket(buffer);
            return null;
        }
        int cmd = buffer.getUByte();
        if (cmd != 61) {
            throw new SshException("Received unexpected message: " + cmd);
        }
        int num = buffer.getInt();
        if (num != 1) {
            throw new SshException("Expected 1 response from user but received " + num);
        }
        String password = buffer.getString();
        return this.checkPassword(this.session, this.username, password);
    }

    protected String getInteractionName() {
        return FactoryManagerUtils.getStringProperty(this.session, KB_INTERACTIVE_NAME_PROP, DEFAULT_KB_INTERACTIVE_NAME);
    }

    protected String getInteractionInstruction() {
        return FactoryManagerUtils.getStringProperty(this.session, KB_INTERACTIVE_INSTRUCTION_PROP, DEFAULT_KB_INTERACTIVE_INSTRUCTION);
    }

    protected String getInteractionLanguage() {
        return FactoryManagerUtils.getStringProperty(this.session, KB_INTERACTIVE_LANG_PROP, DEFAULT_KB_INTERACTIVE_LANG);
    }

    protected String getInteractionPrompt() {
        return FactoryManagerUtils.getStringProperty(this.session, KB_INTERACTIVE_PROMPT_PROP, DEFAULT_KB_INTERACTIVE_PROMPT);
    }

    protected boolean isInteractionPromptEchoEnabled() {
        return FactoryManagerUtils.getBooleanProperty(this.session, KB_INTERACTIVE_ECHO_PROMPT_PROP, false);
    }

    protected boolean checkPassword(ServerSession session, String username, String password) throws Exception {
        ServerFactoryManager manager = session.getFactoryManager();
        PasswordAuthenticator auth = ValidateUtils.checkNotNull(manager.getPasswordAuthenticator(), "No PasswordAuthenticator configured", (Object)GenericUtils.EMPTY_BYTE_ARRAY);
        return auth.authenticate(username, password, session);
    }
}

