/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPassword
extends AbstractUserAuth {
    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        if (!init) {
            throw new IllegalStateException("Incomplete initialization");
        }
        boolean newPassword = buffer.getBoolean();
        if (newPassword) {
            throw new IllegalStateException("Password changes are not supported");
        }
        String password = buffer.getString();
        return this.checkPassword(this.session, this.username, password);
    }

    protected boolean checkPassword(ServerSession session, String username, String password) throws Exception {
        ServerFactoryManager manager = session.getFactoryManager();
        PasswordAuthenticator auth = ValidateUtils.checkNotNull(manager.getPasswordAuthenticator(), "No PasswordAuthenticator configured");
        return auth.authenticate(username, password, session);
    }
}

