/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpException;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;
import org.apache.sshd.client.subsystem.sftp.SftpPath;
import org.apache.sshd.client.subsystem.sftp.SftpPosixFileAttributes;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;

public class SftpPosixFileAttributeView
implements PosixFileAttributeView {
    private final SftpFileSystemProvider provider;
    private final Path path;
    private final LinkOption[] options;

    public SftpPosixFileAttributeView(SftpFileSystemProvider provider, Path path, LinkOption ... options) {
        this.provider = ValidateUtils.checkNotNull(provider, "No file system provider instance");
        this.path = path;
        this.options = options;
    }

    @Override
    public String name() {
        return "view";
    }

    public final SftpFileSystemProvider provider() {
        return this.provider;
    }

    public final Path getPath() {
        return this.path;
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        SftpClient.Attributes attributes;
        SftpPath p = this.provider.toSftpPath(this.path);
        SftpFileSystem fs = (SftpFileSystem)p.getFileSystem();
        try (SftpClient client = fs.getClient();){
            try {
                attributes = IoUtils.followLinks(this.options) ? client.stat(p.toString()) : client.lstat(p.toString());
            }
            catch (SftpException e) {
                if (e.getStatus() == 2) {
                    throw new NoSuchFileException(p.toString());
                }
                throw e;
            }
        }
        return new SftpPosixFileAttributes(this.path, attributes);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        if (lastModifiedTime != null) {
            this.provider.setAttribute(this.path, "lastModifiedTime", lastModifiedTime, this.options);
        }
        if (lastAccessTime != null) {
            this.provider.setAttribute(this.path, "lastAccessTime", lastAccessTime, this.options);
        }
        if (createTime != null) {
            this.provider.setAttribute(this.path, "createTime", createTime, this.options);
        }
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
        this.provider.setAttribute(this.path, "permissions", perms, this.options);
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
        this.provider.setAttribute(this.path, "group", group, this.options);
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.readAttributes().owner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        this.provider.setAttribute(this.path, "owner", owner, this.options);
    }
}

