/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Map;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.Transformer;
import org.apache.sshd.common.util.ValidateUtils;

public class MappedKeyPairProvider
implements KeyPairProvider {
    public static final Transformer<Map<String, KeyPair>, KeyPairProvider> MAP_TO_KEY_PAIR_PROVIDER = new Transformer<Map<String, KeyPair>, KeyPairProvider>(){

        @Override
        public KeyPairProvider transform(Map<String, KeyPair> input) {
            return new MappedKeyPairProvider(input);
        }
    };
    private final Map<String, KeyPair> pairsMap;

    public MappedKeyPairProvider(Map<String, KeyPair> pairsMap) {
        this.pairsMap = ValidateUtils.checkNotNull(pairsMap, "No pairs map provided");
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        return this.pairsMap.values();
    }

    @Override
    public KeyPair loadKey(String type) {
        return this.pairsMap.get(type);
    }

    @Override
    public Iterable<String> getKeyTypes() {
        return this.pairsMap.keySet();
    }

    public String toString() {
        return String.valueOf(this.getKeyTypes());
    }
}

