/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;

public class ProcessShellFactory
extends AbstractLoggingBean
implements Factory<Command> {
    private String[] command;
    private final Set<TtyOptions> ttyOptions;

    public ProcessShellFactory() {
        this(GenericUtils.EMPTY_STRING_ARRAY);
    }

    public ProcessShellFactory(String[] command) {
        this(command, TtyOptions.resolveDefaultTtyOptions());
    }

    public ProcessShellFactory(String[] command, Collection<TtyOptions> ttyOptions) {
        this.command = command;
        this.ttyOptions = GenericUtils.isEmpty(ttyOptions) ? Collections.emptySet() : GenericUtils.of(ttyOptions);
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    @Override
    public Command create() {
        return new InvertedShellWrapper(new ProcessShell());
    }

    public class ProcessShell
    implements InvertedShell {
        private Process process;
        private TtyFilterOutputStream in;
        private TtyFilterInputStream out;
        private TtyFilterInputStream err;

        @Override
        public void start(Map<String, String> env) throws IOException {
            String[] cmds = new String[ProcessShellFactory.this.command.length];
            for (int i = 0; i < cmds.length; ++i) {
                cmds[i] = "$USER".equals(ProcessShellFactory.this.command[i]) ? env.get("USER") : ProcessShellFactory.this.command[i];
            }
            ProcessBuilder builder = new ProcessBuilder(cmds);
            if (GenericUtils.size(env) > 0) {
                try {
                    Map<String, String> procEnv = builder.environment();
                    procEnv.putAll(env);
                }
                catch (Exception e) {
                    ProcessShellFactory.this.log.warn("Could not set environment for command=" + GenericUtils.join(cmds, ' '), (Throwable)e);
                }
            }
            ProcessShellFactory.this.log.info("Starting shell with command: '{}' and env: {}", builder.command(), builder.environment());
            this.process = builder.start();
            this.out = new TtyFilterInputStream(this.process.getInputStream());
            this.err = new TtyFilterInputStream(this.process.getErrorStream());
            this.in = new TtyFilterOutputStream(this.process.getOutputStream(), this.err);
        }

        @Override
        public OutputStream getInputStream() {
            return this.in;
        }

        @Override
        public InputStream getOutputStream() {
            return this.out;
        }

        @Override
        public InputStream getErrorStream() {
            return this.err;
        }

        @Override
        public boolean isAlive() {
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        @Override
        public int exitValue() {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void destroy() {
            if (this.process != null) {
                try {
                    this.process.destroy();
                }
                finally {
                    this.process = null;
                }
            }
        }

        protected class TtyFilterOutputStream
        extends FilterOutputStream {
            private TtyFilterInputStream echo;

            public TtyFilterOutputStream(OutputStream out, TtyFilterInputStream echo) {
                super(out);
                this.echo = echo;
            }

            @Override
            public void write(int c) throws IOException {
                if (c == 10 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.INlCr)) {
                    c = 13;
                } else if (c == 13 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.ICrNl)) {
                    c = 10;
                }
                super.write(c);
                if (ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.Echo)) {
                    this.echo.write(c);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                for (int i = off; i < len; ++i) {
                    this.write(b[i]);
                }
            }
        }

        protected class TtyFilterInputStream
        extends FilterInputStream {
            private Buffer buffer;
            private int lastChar;

            public TtyFilterInputStream(InputStream in) {
                super(in);
                this.buffer = new ByteArrayBuffer(32);
            }

            synchronized void write(int c) {
                this.buffer.putByte((byte)c);
            }

            synchronized void write(byte[] buf, int off, int len) {
                this.buffer.putBytes(buf, off, len);
            }

            @Override
            public int available() throws IOException {
                return super.available() + this.buffer.available();
            }

            @Override
            public synchronized int read() throws IOException {
                int c;
                if (this.buffer.available() > 0) {
                    c = this.buffer.getByte();
                    this.buffer.compact();
                } else {
                    c = super.read();
                }
                if (c == 10 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.ONlCr) && this.lastChar != 13) {
                    c = 13;
                    ByteArrayBuffer buf = new ByteArrayBuffer();
                    ((Buffer)buf).putByte((byte)10);
                    buf.putBuffer(this.buffer);
                    this.buffer = buf;
                } else if (c == 13 && ProcessShellFactory.this.ttyOptions.contains((Object)TtyOptions.OCrNl)) {
                    c = 10;
                }
                this.lastChar = c;
                return c;
            }

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                int nb;
                if (this.buffer.available() == 0) {
                    nb = super.read(b, off, len);
                    this.buffer.putRawBytes(b, off, nb);
                }
                nb = 0;
                while (nb < len && this.buffer.available() > 0) {
                    b[off + nb++] = (byte)this.read();
                }
                return nb;
            }
        }
    }

    public static enum TtyOptions {
        Echo,
        INlCr,
        ICrNl,
        ONlCr,
        OCrNl;

        public static final Set<TtyOptions> LINUX_OPTIONS;
        public static final Set<TtyOptions> WINDOWS_OPTIONS;

        public static Set<TtyOptions> resolveDefaultTtyOptions() {
            return TtyOptions.resolveTtyOptions(OsUtils.isWin32());
        }

        public static Set<TtyOptions> resolveTtyOptions(boolean isWin32) {
            if (isWin32) {
                return WINDOWS_OPTIONS;
            }
            return LINUX_OPTIONS;
        }

        static {
            LINUX_OPTIONS = Collections.unmodifiableSet(EnumSet.of(ONlCr));
            WINDOWS_OPTIONS = Collections.unmodifiableSet(EnumSet.of(Echo, ICrNl, ONlCr));
        }
    }
}

