/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class UserAuthKeyboardInteractive
extends AbstractLoggingBean
implements UserAuth {
    private ClientSession session;
    private String service;
    private Iterator<String> passwords;
    private String current;
    private int nbTrials;
    private int maxTrials;

    @Override
    public void init(ClientSession session, String service, Collection<?> identities) throws Exception {
        this.session = session;
        this.service = service;
        ArrayList<String> pwds = new ArrayList<String>();
        for (Object o : identities) {
            if (!(o instanceof String)) continue;
            pwds.add((String)o);
        }
        this.passwords = pwds.iterator();
        this.maxTrials = session.getIntProperty("password-prompts", 3);
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        if (buffer == null) {
            if (this.passwords.hasNext()) {
                this.current = this.passwords.next();
            } else if (this.nbTrials++ < this.maxTrials) {
                this.current = null;
            } else {
                return false;
            }
            String username = this.session.getUsername();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for keyboard-interactive - user={}, service={}", (Object)username, (Object)this.service);
            }
            buffer = this.session.createBuffer((byte)50);
            buffer.putString(this.session.getUsername());
            buffer.putString(this.service);
            buffer.putString("keyboard-interactive");
            buffer.putString("");
            buffer.putString("");
            this.session.writePacket(buffer);
            return true;
        }
        int cmd = buffer.getUByte();
        if (cmd == 60) {
            String[] rep;
            this.log.debug("Received SSH_MSG_USERAUTH_INFO_REQUEST");
            String name = buffer.getString();
            String instruction = buffer.getString();
            String language_tag = buffer.getString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("SSH_MSG_USERAUTH_INFO_REQUEST name={} instruction={} language={}", new Object[]{name, instruction, language_tag});
            }
            int num = buffer.getInt();
            Object[] prompt = new String[num];
            boolean[] echo = new boolean[num];
            for (int i = 0; i < num; ++i) {
                prompt[i] = buffer.getString();
                echo[i] = buffer.getBoolean();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Prompt: {}", (Object)Arrays.toString(prompt));
                this.log.debug("Echo: {}", (Object)echo);
            }
            if ((rep = this.getUserResponses(name, instruction, language_tag, (String[])prompt, echo)) == null) {
                return false;
            }
            if (num != rep.length) {
                this.log.warn("Mismatched prompts (" + num + ") vs. responses count (" + rep.length + ")");
            }
            buffer = this.session.createBuffer((byte)61);
            buffer.putInt(rep.length);
            for (String r : rep) {
                buffer.putString(r);
            }
            this.session.writePacket(buffer);
            return true;
        }
        throw new IllegalStateException("Received unknown packet: cmd=" + cmd);
    }

    protected String getCurrentPasswordCandidate() {
        return this.current;
    }

    protected String[] getUserResponses(String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        int num = GenericUtils.length(prompt);
        if (num == 0) {
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        String candidate = this.getCurrentPasswordCandidate();
        if (this.useCurrentPassword(candidate, name, instruction, lang, prompt, echo)) {
            return new String[]{candidate};
        }
        UserInteraction ui = this.session.getUserInteraction();
        if (ui == null) {
            ClientFactoryManager manager = this.session.getFactoryManager();
            ui = manager.getUserInteraction();
        }
        if (ui != null) {
            String dest = this.session.getUsername() + "@" + this.session.getIoSession().getRemoteAddress().toString();
            return ui.interactive(dest, name, instruction, lang, prompt, echo);
        }
        return null;
    }

    protected boolean useCurrentPassword(String password, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        int num = GenericUtils.length(prompt);
        if (num != 1 || password == null || echo[0]) {
            return false;
        }
        String value = prompt[0].toLowerCase();
        int passPos = value.lastIndexOf("password");
        if (passPos < 0) {
            return false;
        }
        int sepPos = value.lastIndexOf(58);
        return sepPos > passPos;
    }

    @Override
    public void destroy() {
    }
}

