/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.server.shell.ProcessShellFactory;

public class InteractiveProcessShellFactory
extends ProcessShellFactory {
    public static final InteractiveProcessShellFactory INSTANCE;
    private static final String[] LINUX_COMMAND;
    private static final String[] WINDOWS_COMMAND;

    public InteractiveProcessShellFactory() {
        super(InteractiveProcessShellFactory.resolveDefaultInteractiveCommand(), ProcessShellFactory.TtyOptions.resolveDefaultTtyOptions());
    }

    public static String[] resolveDefaultInteractiveCommand() {
        return InteractiveProcessShellFactory.resolveInteractiveCommand(OsUtils.isWin32());
    }

    public static String[] resolveInteractiveCommand(boolean isWin32) {
        if (isWin32) {
            return (String[])WINDOWS_COMMAND.clone();
        }
        return (String[])LINUX_COMMAND.clone();
    }

    static {
        LINUX_COMMAND = new String[]{"/bin/sh", "-i", "-l"};
        WINDOWS_COMMAND = new String[]{"cmd.exe"};
        INSTANCE = new InteractiveProcessShellFactory();
    }
}

