/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ssl.impl;

import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.impl.AliasKeyManager;
import org.apache.ftpserver.ssl.impl.ExtendedAliasKeyManager;
import org.apache.ftpserver.util.ClassUtils;

public class DefaultSslConfiguration
implements SslConfiguration {
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private String sslProtocol = "TLS";
    private ClientAuth clientAuth = ClientAuth.NONE;
    private String keyAlias;
    private String[] enabledCipherSuites;

    public DefaultSslConfiguration(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, ClientAuth clientAuthReqd, String sslProtocol, String[] enabledCipherSuites, String keyAlias) {
        this.clientAuth = clientAuthReqd;
        this.enabledCipherSuites = enabledCipherSuites;
        this.keyAlias = keyAlias;
        this.keyManagerFactory = keyManagerFactory;
        this.sslProtocol = sslProtocol;
        this.trustManagerFactory = trustManagerFactory;
    }

    public SSLContext getSSLContext(String protocol) throws GeneralSecurityException {
        if (protocol == null) {
            protocol = this.sslProtocol;
        }
        KeyManager[] keyManagers = this.keyManagerFactory.getKeyManagers();
        for (int i = 0; i < keyManagers.length; ++i) {
            if (ClassUtils.extendsClass(keyManagers[i].getClass(), "javax.net.ssl.X509ExtendedKeyManager")) {
                keyManagers[i] = new ExtendedAliasKeyManager(keyManagers[i], this.keyAlias);
                continue;
            }
            if (!(keyManagers[i] instanceof X509KeyManager)) continue;
            keyManagers[i] = new AliasKeyManager(keyManagers[i], this.keyAlias);
        }
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(keyManagers, this.trustManagerFactory.getTrustManagers(), null);
        return ctx;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public SSLContext getSSLContext() throws GeneralSecurityException {
        return this.getSSLContext(this.sslProtocol);
    }

    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuites != null) {
            return (String[])this.enabledCipherSuites.clone();
        }
        return null;
    }
}

