/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public abstract class AbstractSignature
implements Signature {
    protected java.security.Signature signature;
    private final String algorithm;

    protected AbstractSignature(String algorithm) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No signature algorithm specified");
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void initVerifier(PublicKey key) throws Exception {
        this.signature = SecurityUtils.getSignature(this.getAlgorithm());
        this.signature.initVerify(ValidateUtils.checkNotNull(key, "No public key provided"));
    }

    @Override
    public void initSigner(PrivateKey key) throws Exception {
        this.signature = SecurityUtils.getSignature(this.getAlgorithm());
        this.signature.initSign(ValidateUtils.checkNotNull(key, "No private key provided"));
    }

    @Override
    public void update(byte[] hash) throws Exception {
        this.update(hash, 0, GenericUtils.length(hash));
    }

    @Override
    public void update(byte[] hash, int off, int len) throws Exception {
        this.signature.update(hash, off, len);
    }

    protected Pair<String, byte[]> extractEncodedSignature(byte[] sig) {
        int dataLen = GenericUtils.length(sig);
        if (dataLen < 8) {
            return null;
        }
        long keyTypeLen = BufferUtils.getUInt(sig, 0, dataLen);
        if (keyTypeLen >= (long)(dataLen - 4)) {
            return null;
        }
        int keyTypeStartPos = 4;
        int keyTypeEndPos = keyTypeStartPos + (int)keyTypeLen;
        int remainLen = dataLen - keyTypeEndPos;
        if (remainLen < 4) {
            return null;
        }
        long dataBytesLen = BufferUtils.getUInt(sig, keyTypeEndPos, remainLen);
        if (dataBytesLen > (long)(remainLen - 4)) {
            return null;
        }
        String keyType = new String(sig, keyTypeStartPos, (int)keyTypeLen, StandardCharsets.UTF_8);
        byte[] data = new byte[(int)dataBytesLen];
        System.arraycopy(sig, keyTypeEndPos + 4, data, 0, (int)dataBytesLen);
        return new Pair<String, byte[]>(keyType, data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAlgorithm() + "]";
    }
}

